/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp;

import com.xdja.imsdk.http.RequestInfo;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class OkHttpRequest {
    private static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");

    public static Request builderRequest(RequestInfo info) {
        if (info == null) {
            return null;
        }
        Request.Builder builder = new Request.Builder().url(info.getUrl());
        RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)info.getJson());
        builder.post(body);
        Headers.Builder headerBuilder = new Headers.Builder();
        if (info.getHeaders() == null || info.getHeaders().isEmpty()) {
            return builder.build();
        }
        for (String key : info.getHeaders().keySet()) {
            if (info.getHeaders().get(key) == null) continue;
            headerBuilder.add(key, info.getHeaders().get(key));
        }
        builder.headers(headerBuilder.build());
        builder.tag((Object)info.getTag());
        return builder.build();
    }

    public static Request builderRequest(String url, String json) {
        Request.Builder builder = new Request.Builder().url(url);
        RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)json);
        builder.post(body);
        return builder.build();
    }

    public static Request builderRequest(String url, Map<String, String> headers, String json) {
        Request.Builder builder = new Request.Builder().url(url);
        RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)json);
        builder.post(body);
        Headers.Builder headerBuilder = new Headers.Builder();
        if (headers == null || headers.isEmpty()) {
            return builder.build();
        }
        for (String key : headers.keySet()) {
            if (headers.get(key) == null) continue;
            headerBuilder.add(key, headers.get(key));
        }
        builder.headers(headerBuilder.build());
        return builder.build();
    }
}

