/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.logger;

import com.xdja.imsdk.http.bean.MsgBean;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.IMSession;
import com.xdja.imsdk.util.ToolUtils;
import java.util.List;

public class DebugHelper {
    public static void logIMSessions(String tag, List<IMSession> sessions) {
        if (sessions == null || sessions.isEmpty()) {
            Logger.getLogger().d(String.valueOf(tag) + sessions);
        } else {
            Logger.getLogger().d(String.valueOf(tag) + "--------------------------[SESSION BEGIN]-----------------------------");
            for (IMSession session : sessions) {
                StringBuilder builder = new StringBuilder("[");
                builder.append(session.getId()).append(", ").append(session.getImPartner()).append(", ").append(session.getRemindCount()).append(", ").append(ToolUtils.getFormatTime(session.getDisplayTime())).append(", last msg {");
                if (session.getLastMessage() != null) {
                    builder.append(session.getLastMessage().getIMMessageId()).append(", ").append(session.getLastMessage().getFrom()).append(", ").append(session.getLastMessage().getState()).append(", ").append(session.getLastMessage().getFailCode()).append(", ").append("\n").append(session.getLastMessage().getMessageBody()).append("}]");
                } else {
                    builder.append(session.getLastMessage()).append("}]");
                }
                Logger.getLogger().d(String.valueOf(tag) + builder.toString());
            }
            Logger.getLogger().d(String.valueOf(tag) + "--------------------------[SESSION END]-----------------------------");
        }
    }

    public static void logIMMessages(String tag, List<IMMessage> messages) {
        if (messages == null || messages.isEmpty()) {
            Logger.getLogger().d(String.valueOf(tag) + messages);
        } else {
            Logger.getLogger().d(String.valueOf(tag) + "--------------------------[MESSAGE BEGIN]-----------------------------");
            for (IMMessage message : messages) {
                Logger.getLogger().d(String.valueOf(tag) + message);
            }
            Logger.getLogger().d(String.valueOf(tag) + "--------------------------[MESSAGE END]-----------------------------");
        }
    }

    public static void logMsgBean(String tag, List<MsgBean> list) {
        tag = String.valueOf(tag) + ", time = " + System.currentTimeMillis();
        if (list == null || list.isEmpty()) {
            Logger.getLogger().d(String.valueOf(tag) + list);
        } else {
            Logger.getLogger().d(String.valueOf(tag) + "--------------------------[RECEIVE BEGIN]-----------------------------");
            for (MsgBean msg : list) {
                if (msg.isStateMsg()) {
                    Logger.getLogger().d(String.valueOf(tag) + " [" + msg.getI() + ", " + msg.getC() + ", " + msg.getStat() + "] " + "\n");
                    continue;
                }
                Logger.getLogger().d(String.valueOf(tag) + msg);
            }
            Logger.getLogger().d(String.valueOf(tag) + "--------------------------[RECEIVE END]-----------------------------");
        }
    }
}

