/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.logger;

import com.xdja.imsdk.manager.ImSdkCallbackManager;
import java.util.Hashtable;

public class Logger {
    public static final String tag = "XdjaImSdkLog";
    private static final boolean logFlag = true;
    private static final int logLevel = 2;
    private static Hashtable<String, Logger> loggerTable = new Hashtable();
    private static Logger logger;
    private static boolean isDebug;
    private String className;

    static {
        isDebug = true;
    }

    private Logger(String name) {
        this.className = name;
    }

    private static Logger getLoggerClass(String className) {
        Logger classLogger = loggerTable.get(className);
        if (classLogger == null) {
            classLogger = new Logger(className);
            loggerTable.put(className, classLogger);
        }
        return classLogger;
    }

    public static Logger getLogger(String Tag) {
        if (logger == null) {
            logger = new Logger(Tag);
        }
        return logger;
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = new Logger(tag);
        }
        return logger;
    }

    public boolean debug() {
        return true;
    }

    public void v(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            ImSdkCallbackManager.getInstance().callbackLog(2, tag, String.valueOf(name) + " - " + str, null);
        } else {
            ImSdkCallbackManager.getInstance().callbackLog(2, tag, str.toString(), null);
        }
    }

    public void d(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            ImSdkCallbackManager.getInstance().callbackLog(3, tag, String.valueOf(name) + " - " + str, null);
        } else {
            ImSdkCallbackManager.getInstance().callbackLog(3, tag, str.toString(), null);
        }
    }

    public void i(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            ImSdkCallbackManager.getInstance().callbackLog(4, tag, String.valueOf(name) + " - " + str, null);
        } else {
            ImSdkCallbackManager.getInstance().callbackLog(4, tag, str.toString(), null);
        }
    }

    public void w(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            ImSdkCallbackManager.getInstance().callbackLog(5, tag, String.valueOf(name) + " - " + str, null);
        } else {
            ImSdkCallbackManager.getInstance().callbackLog(5, tag, str.toString(), null);
        }
    }

    public void w(Object str, Throwable tr) {
        String name = this.getFunctionName();
        if (name != null) {
            ImSdkCallbackManager.getInstance().callbackLog(5, tag, String.valueOf(name) + " - " + str, tr);
        } else {
            ImSdkCallbackManager.getInstance().callbackLog(5, tag, str.toString(), tr);
        }
    }

    public void e(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            ImSdkCallbackManager.getInstance().callbackLog(6, tag, String.valueOf(name) + " - " + str, null);
        } else {
            ImSdkCallbackManager.getInstance().callbackLog(6, tag, str.toString(), null);
        }
    }

    public void e(String log, Throwable tr) {
        String line = this.getFunctionName();
        ImSdkCallbackManager.getInstance().callbackLog(6, tag, "{Thread:" + Thread.currentThread().getName() + "}" + "[" + this.className + line + ":] " + log + "\n", tr);
    }

    private String getFunctionName() {
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        if (sts == null) {
            return null;
        }
        StackTraceElement[] stackTraceElementArray = sts;
        int n = sts.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement st = stackTraceElementArray[n2];
            if (!(st.isNativeMethod() || st.getClassName().equals(Thread.class.getName()) || st.getClassName().equals(this.getClass().getName()))) {
                Thread t = Thread.currentThread();
                long id = t.getId();
                String name = t.getName();
                return "[(" + id + ", " + name + "): " + st.getFileName() + ":" + st.getLineNumber() + " " + st.getMethodName() + "]";
            }
            ++n2;
        }
        return null;
    }
}

