/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley.request;

import com.xdja.imsdk.volley.NetworkResponse;
import com.xdja.imsdk.volley.Response;
import com.xdja.imsdk.volley.error.CancelError;
import com.xdja.imsdk.volley.error.ParseError;
import com.xdja.imsdk.volley.request.JsonRequest;
import com.xdja.imsdk.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonObjectRequest
extends JsonRequest<JSONObject> {
    public JsonObjectRequest(int method, String url, JSONObject jsonRequest, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        super(method, url, jsonRequest == null ? null : jsonRequest.toString(), listener, errorListener);
    }

    public JsonObjectRequest(String url, JSONObject jsonRequest, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        this(jsonRequest == null ? 0 : 1, url, jsonRequest, listener, errorListener);
    }

    @Override
    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
        if (!this.isCanceled()) {
            try {
                String jsonString = new String(response.data, HttpHeaderParser.parseCharset(response.headers, "utf-8"));
                return Response.success(new JSONObject(jsonString), HttpHeaderParser.parseCacheHeaders(response));
            }
            catch (UnsupportedEncodingException e) {
                return Response.error(new ParseError(e));
            }
            catch (JSONException je) {
                return Response.error(new ParseError(je));
            }
        }
        return Response.error(new CancelError("Request was Canceled!"));
    }
}

