/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.database;

import android.content.Context;
import android.content.ContextWrapper;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.xdja.im.common.utils.CachePath;
import java.io.File;
import java.io.IOException;

public class DBContext
extends ContextWrapper {
    private Context context;
    private String account;

    public DBContext(Context context, String account) {
        super(context);
        this.context = context;
        this.account = account;
    }

    public File getDatabasePath(String name) {
        if (this.context == null || TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        String dirBuilder = CachePath.getParentDbPath() + File.separator + this.account;
        File dir = new File(dirBuilder);
        File file = new File(dir, name);
        boolean mkDir = false;
        if (!dir.exists()) {
            mkDir = dir.mkdirs();
        }
        if (mkDir && !file.exists()) {
            try {
                if (file.createNewFile()) {
                    return file;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
        if (this.context == null || TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        SQLiteDatabase result = SQLiteDatabase.openOrCreateDatabase((File)this.getDatabasePath(name), (SQLiteDatabase.CursorFactory)factory);
        return result;
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        if (this.context == null || TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        SQLiteDatabase result = SQLiteDatabase.openOrCreateDatabase((File)this.getDatabasePath(name), (SQLiteDatabase.CursorFactory)factory);
        return result;
    }
}

