/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.adapter;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import com.xdja.im.lib.filemanage.commend.Command;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.view.AdapterVu;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.List;
import java.util.Map;

public abstract class BaseFileItemAdapterPresenter<P extends Command, D>
extends BaseExpandableListAdapter {
    protected Context mContext;
    private LayoutInflater inflater;
    protected List<HistoryFileCategory> mTitles;
    protected Map<HistoryFileCategory, List<D>> mDatas;

    public int getGroupCount() {
        return this.mTitles != null ? this.mTitles.size() : 0;
    }

    public int getChildrenCount(int groupPosition) {
        List<D> children = this.mDatas.get(this.mTitles.get(groupPosition));
        return this.mDatas != null && children != null ? children.size() : 0;
    }

    public String getGroup(int groupPosition) {
        return this.mTitles != null ? this.mTitles.get(groupPosition).getCategoryId() : "";
    }

    public D getChild(int groupPosition, int childPosition) {
        List<D> results = this.mDatas.get(this.mTitles.get(groupPosition));
        return results != null ? (D)results.get(childPosition) : null;
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return 0L;
    }

    public boolean hasStableIds() {
        return false;
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        AdapterVu<P, String> adapterVu = null;
        if (convertView == null) {
            if (this.inflater == null) {
                this.inflater = (LayoutInflater)parent.getContext().getSystemService("layout_inflater");
            }
            try {
                Class<AdapterVu<P, String>> aClass = this.getGroupVuClassByViewType(0);
                if (aClass != null) {
                    adapterVu = aClass.newInstance();
                    adapterVu.setCommand(this.getCommand());
                    adapterVu.setActivity(this.getActivity());
                    adapterVu.init(this.inflater, parent);
                    convertView = adapterVu.getView();
                    convertView.setTag(adapterVu);
                    adapterVu.onViewCreated();
                }
            }
            catch (Exception e) {
                LogUtil.e("", e.getMessage());
            }
        } else {
            adapterVu = (AdapterVu<P, String>)convertView.getTag();
            adapterVu.onViewReused();
        }
        if (adapterVu != null) {
            adapterVu.bindDataSource(groupPosition, this.getGroup(groupPosition));
        }
        return convertView;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        AdapterVu<P, D> adapterVu = null;
        if (convertView == null) {
            if (this.inflater == null) {
                this.inflater = (LayoutInflater)parent.getContext().getSystemService("layout_inflater");
            }
            try {
                Class<AdapterVu<P, D>> aClass = this.getVuClassByViewType(0);
                if (aClass != null) {
                    adapterVu = aClass.newInstance();
                    adapterVu.setCommand(this.getCommand());
                    adapterVu.setActivity(this.getActivity());
                    adapterVu.init(this.inflater, parent);
                    convertView = adapterVu.getView();
                    convertView.setTag(adapterVu);
                    adapterVu.onViewCreated();
                }
            }
            catch (Exception e) {
                LogUtil.e("", e.getMessage());
            }
        } else {
            adapterVu = (AdapterVu<P, D>)convertView.getTag();
            adapterVu.onViewReused();
        }
        if (adapterVu != null) {
            adapterVu.bindDataSource(groupPosition, this.getChild(groupPosition, childPosition));
        }
        return convertView;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return false;
    }

    protected abstract List<Class<? extends AdapterVu<P, D>>> getVuClasses();

    protected abstract List<Class<? extends AdapterVu<P, String>>> getGroupVuClasses();

    protected abstract P getCommand();

    private Class<? extends AdapterVu<P, D>> getVuClassByViewType(int itemViewType) {
        if (this.getVuClasses() != null && itemViewType < this.getVuClasses().size()) {
            return this.getVuClasses().get(itemViewType);
        }
        return null;
    }

    private Class<? extends AdapterVu<P, String>> getGroupVuClassByViewType(int itemViewType) {
        if (this.getVuClasses() != null && itemViewType < this.getVuClasses().size()) {
            return this.getGroupVuClasses().get(itemViewType);
        }
        return null;
    }

    public Activity getActivity() {
        return null;
    }
}

