/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.annotation;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ActivityStack {
    @Nullable
    private static ActivityStack instance;
    private LinkedList<Activity> activities = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static ActivityStack getInstanse() {
        if (instance != null) return instance;
        Class<ActivityStack> clazz = ActivityStack.class;
        synchronized (ActivityStack.class) {
            if (instance != null) return instance;
            instance = new ActivityStack();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ActivityStack() {
    }

    @NonNull
    public LinkedList<Activity> getAllActivities() {
        return this.activities;
    }

    @Nullable
    public Activity getTopActivity() {
        if (this.activities == null || this.activities.isEmpty()) {
            return null;
        }
        return this.activities.getFirst();
    }

    @Nullable
    public Activity getTopActivityExclude(String activity) {
        if (this.activities == null || this.activities.isEmpty()) {
            return null;
        }
        for (Activity mActivity : this.activities) {
            if (mActivity.getLocalClassName().equals(activity)) continue;
            return mActivity;
        }
        return this.activities.getFirst();
    }

    @Nullable
    public Activity getTopActivityExclude(String[] exclude) {
        if (this.activities == null || this.activities.isEmpty()) {
            return null;
        }
        int n = this.activities.size();
        for (int i = this.activities.size() - 1; i > n; --i) {
            Activity activity = this.activities.get(i);
            boolean mark = false;
            int m = exclude.length;
            for (int k = 0; k < m; ++k) {
                if (!activity.getLocalClassName().equals(exclude[k])) continue;
                mark = true;
            }
            if (mark) continue;
            return activity;
        }
        return this.activities.getFirst();
    }

    public void pushActivity(@NonNull Activity activity) {
        this.activities.addFirst(activity);
    }

    public boolean popActivity(@NonNull Activity activity, boolean isFinish) {
        if (this.activities.isEmpty()) {
            return false;
        }
        if (this.activities.contains(activity)) {
            if (isFinish) {
                activity.finish();
            }
            return this.activities.remove(activity);
        }
        return false;
    }

    public void popAllActivities(boolean isFinish) {
        if (this.activities.isEmpty()) {
            return;
        }
        if (isFinish) {
            Iterator iterator = this.activities.iterator();
            while (iterator.hasNext()) {
                ((Activity)iterator.next()).finish();
            }
        }
        this.activities.clear();
    }

    public void goBackApp() {
        Activity activity = this.getTopActivity();
        if (activity == null || !ActivityStack.isAppOnForeground((Context)activity)) {
            return;
        }
        this.popActivity(activity, true);
        this.moveToBackAllActivities();
    }

    public void moveToBackAllActivities() {
        Activity activity = this.getTopActivity();
        if (activity == null || !ActivityStack.isAppOnForeground((Context)activity)) {
            return;
        }
        try {
            activity.moveTaskToBack(true);
        }
        catch (Exception e) {
            LogUtil.e("", "moveToBackAllActivities->moveTaskToBack error : " + e != null ? e.toString() : "NULL");
        }
    }

    public void popActivitiesUntil(int position, boolean isFinish) {
        if (this.activities.isEmpty() || position < 0) {
            return;
        }
        for (int i = 0; i < position; ++i) {
            if (isFinish) {
                this.activities.getFirst().finish();
            }
            this.activities.removeFirst();
        }
    }

    public void popActivitiesUntil(@NonNull Activity activity, boolean isFinish) {
        if (this.activities.isEmpty() || !this.activities.contains(activity)) {
            return;
        }
        int posistion = this.activities.indexOf(activity) - 1;
        this.popActivitiesUntil(posistion, isFinish);
    }

    public void pop2TopActivity(boolean isFinish) {
        int position = this.activities.size() - 1;
        for (int i = 0; i < position; ++i) {
            if (isFinish) {
                this.activities.getLast().finish();
            }
            this.activities.removeLast();
        }
    }

    public <T extends Activity> void popActivitiesUntil(@NonNull Class<T> cls, boolean isFinish) {
        if (this.activities.isEmpty()) {
            return;
        }
        int posistion = -1;
        for (int i = 0; i < this.activities.size(); ++i) {
            if (!this.activities.get(i).getClass().equals(cls)) continue;
            posistion = i;
            break;
        }
        this.popActivitiesUntil(posistion, isFinish);
    }

    public void popActivityByClass(@NonNull Class<? extends Activity> cs, boolean isFinish) {
        Activity ac = this.getActivityByClass(cs);
        if (ac != null) {
            this.popActivity(ac, isFinish);
        }
    }

    public void exitApp() {
        this.popAllActivities(true);
    }

    @Nullable
    public Activity getActivityByClassName(@NonNull String activityName) {
        if (this.activities.isEmpty()) {
            return null;
        }
        for (Activity ac : this.activities) {
            if (!ac.getClass().getName().contains(activityName)) continue;
            return ac;
        }
        return null;
    }

    @Nullable
    public Activity getActivityByClass(Class<? extends Activity> cs) {
        if (this.activities.isEmpty()) {
            return null;
        }
        for (Activity ac : this.activities) {
            if (!ac.getClass().equals(cs)) continue;
            return ac;
        }
        return null;
    }

    public static boolean isAppOnForeground(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List appInfos = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo info : appInfos) {
            if (!info.processName.equals(context.getPackageName()) || info.importance != 100) continue;
            return true;
        }
        return false;
    }
}

