/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.fragment;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.lib.filemanage.adapter.LastFilePageAdapter;
import com.xdja.im.lib.filemanage.commend.ILastFileListVu;
import com.xdja.im.lib.filemanage.commend.ILastFilePageCommand;
import com.xdja.im.lib.filemanage.fragment.LastFileListFragment;
import com.xdja.im.lib.filemanage.fragment.LastPhotoAndVideoFragment;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.presenter.IMFragmentPresenter;
import com.xdja.im.lib.filemanage.view.ViewLastFileList;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import rx.Subscriber;

public class LastFilePagePresenter
extends IMFragmentPresenter<ILastFilePageCommand, ILastFileListVu>
implements ILastFilePageCommand {
    private static final int MAX_SELECT_COUNT = 9;
    private LastPhotoAndVideoFragment lastPhotoAndVideoFragment;
    private LastFileListFragment lastDocumentFragment;
    private LastFileListFragment lastOtherFragment;
    private Map<HistoryFileCategory, List<TalkMessageBean>> mPhotoAndVideoDatas = new HashMap<HistoryFileCategory, List<TalkMessageBean>>();
    private Map<HistoryFileCategory, List<TalkMessageBean>> mDocumentDatas = new HashMap<HistoryFileCategory, List<TalkMessageBean>>();
    private Map<HistoryFileCategory, List<TalkMessageBean>> mOtherDatas = new HashMap<HistoryFileCategory, List<TalkMessageBean>>();
    BusProvider busProvider;

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (null == this.useCaseComponent) {
            LogUtil.e("LastFilePagePresenter", "useCaseComponent is null");
            return;
        }
        this.useCaseComponent.inject(this);
        this.busProvider = BusProvider.getInstance();
        this.busProvider.register(this);
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        this.lastPhotoAndVideoFragment = new LastPhotoAndVideoFragment();
        this.lastDocumentFragment = new LastFileListFragment();
        this.lastOtherFragment = new LastFileListFragment();
        fragments.add(this.lastPhotoAndVideoFragment);
        fragments.add(this.lastDocumentFragment);
        fragments.add(this.lastOtherFragment);
        LastFilePageAdapter mAdapter = this.buildAdapter(fragments);
        ((ILastFileListVu)this.getVu()).setFragmentAdapter(mAdapter);
    }

    @Subscribe
    public void obtainDatas(IMProxyEvent.FileUpdateEvent event) {
        ImUiKit.getInstance().getComponent().proxyRepository().getAllHistoryFileInfoWithTalkId("", 0).subscribe((Subscriber)new Subscriber<Map<HistoryFileCategory, List<TalkMessageBean>>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Map<HistoryFileCategory, List<TalkMessageBean>> dataMaps) {
                for (Map.Entry<HistoryFileCategory, List<TalkMessageBean>> entry : dataMaps.entrySet()) {
                    List<TalkMessageBean> talkMsgs = entry.getValue();
                    LinkedList<TalkMessageBean> filterMsgs1 = new LinkedList<TalkMessageBean>();
                    LinkedList<TalkMessageBean> filterMsgs2 = new LinkedList<TalkMessageBean>();
                    LinkedList<TalkMessageBean> filterMsgs3 = new LinkedList<TalkMessageBean>();
                    for (TalkMessageBean bean : talkMsgs) {
                        FileInfo fileInfo = bean.getFileInfo();
                        int fileState = fileInfo instanceof VideoFileInfo ? ((VideoFileInfo)fileInfo).getRawFileInfo().getFileState() : (fileInfo instanceof ImageFileInfo ? (((ImageFileInfo)fileInfo).isOriginal() ? ((ImageFileInfo)fileInfo).getRawFileInfo().getFileState() : fileInfo.getFileState()) : fileInfo.getFileState());
                        if (fileState != 2 || bean.getMessageState() == 0 || bean.getMessageState() == 1) continue;
                        int fileType = FileUtils.getTypeWithSuffix(fileInfo.getFilePath());
                        if ((fileType == 11 || fileType == 12) && fileInfo.getFileType() != fileType) {
                            fileType = fileInfo.getFileType();
                        }
                        bean.getFileInfo().setFileType(fileType);
                        if (fileType == 3) {
                            filterMsgs1.add(bean);
                            continue;
                        }
                        if (fileType == 2) {
                            filterMsgs1.add(bean);
                            continue;
                        }
                        if (fileType == 5 || fileType == 9 || fileType == 6 || fileType == 7 || fileType == 8) {
                            filterMsgs2.add(bean);
                            continue;
                        }
                        filterMsgs3.add(bean);
                    }
                    if (filterMsgs1.size() > 0) {
                        LastFilePagePresenter.this.mPhotoAndVideoDatas.put(entry.getKey(), filterMsgs1);
                    }
                    if (filterMsgs2.size() > 0) {
                        LastFilePagePresenter.this.mDocumentDatas.put(entry.getKey(), filterMsgs2);
                    }
                    if (filterMsgs3.size() <= 0) continue;
                    LastFilePagePresenter.this.mOtherDatas.put(entry.getKey(), filterMsgs3);
                }
                LastFilePagePresenter.this.lastPhotoAndVideoFragment.notifyDataChange(LastFilePagePresenter.this.mPhotoAndVideoDatas);
                LastFilePagePresenter.this.lastDocumentFragment.notifyDataChange(LastFilePagePresenter.this.mDocumentDatas);
                LastFilePagePresenter.this.lastOtherFragment.notifyDataChange(LastFilePagePresenter.this.mOtherDatas);
            }
        });
    }

    @Override
    @NonNull
    protected Class<? extends ILastFileListVu> getVuClass() {
        return ViewLastFileList.class;
    }

    @Override
    @NonNull
    protected ILastFilePageCommand getCommand() {
        return this;
    }

    private LastFilePageAdapter buildAdapter(final List<Fragment> fragments) {
        return new LastFilePageAdapter(this.getFragmentManager()){

            @Override
            public Fragment getItem(int position) {
                return (Fragment)fragments.get(position);
            }

            public int getCount() {
                return fragments.size();
            }
        };
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (this.busProvider != null) {
            this.busProvider.unregister(this);
        }
    }
}

