/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.view;

import android.content.SharedPreferences;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.lib.filemanage.commend.ILocalFileListCommand;
import com.xdja.im.lib.filemanage.view.FragmentSuperView;
import com.xdja.im.lib.filemanage.view.ILocalFileListVu;
import com.xdja.im.uikit.R;

public class ViewLocalFileList
extends FragmentSuperView<ILocalFileListCommand>
implements ILocalFileListVu<ILocalFileListCommand>,
View.OnClickListener,
ViewPager.OnPageChangeListener {
    private final int[] mTabSrcId = new int[]{R.id.tv_local_video, R.id.tv_local_image, R.id.tv_local_document, R.id.tv_local_application, R.id.tv_local_other};
    private ViewPager mViewPager;
    private ImageView mCursorImg;
    private int mCursorW = 0;
    private TextView[] mTabTvs;
    private SharedPreferences sharedPreferences;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_local_file;
    }

    @Override
    protected void injectView() {
        super.injectView();
        if (this.getView() != null) {
            this.mViewPager = (ViewPager)this.getView().findViewById(R.id.pager_local_files);
            this.mCursorImg = (ImageView)this.getView().findViewById(R.id.img_cursor);
            TextView mTabVideoTv = (TextView)this.getView().findViewById(R.id.tv_local_video);
            TextView mTabImageTv = (TextView)this.getView().findViewById(R.id.tv_local_image);
            TextView mTabDocxTv = (TextView)this.getView().findViewById(R.id.tv_local_document);
            TextView mTabAppTv = (TextView)this.getView().findViewById(R.id.tv_local_application);
            TextView mTabOtherTv = (TextView)this.getView().findViewById(R.id.tv_local_other);
            this.mTabTvs = new TextView[]{mTabVideoTv, mTabImageTv, mTabDocxTv, mTabAppTv, mTabOtherTv};
            this.mTabTvs[0].setTextColor(this.getColorRes(R.color.base_black_95));
            DisplayMetrics dm = new DisplayMetrics();
            this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
            int screenW = dm.widthPixels;
            this.mCursorW = screenW / this.mTabTvs.length;
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mCursorImg.getLayoutParams();
            params.width = this.mCursorW;
            this.mCursorImg.setLayoutParams((ViewGroup.LayoutParams)params);
            for (TextView mTabTv : this.mTabTvs) {
                mTabTv.setOnClickListener((View.OnClickListener)this);
            }
            this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }
        this.sharedPreferences = this.getActivity().getSharedPreferences("PageTabPositionRecord", 0);
    }

    @Override
    public void setFragmentAdapter(PagerAdapter adapter) {
        this.mViewPager.setAdapter(adapter);
        this.mViewPager.setCurrentItem(this.sharedPreferences.getInt("local_file_page_position", 0));
    }

    @Override
    public void onDestroyView() {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putInt("local_file_page_position", this.mViewPager.getCurrentItem());
        editor.apply();
        super.onDestroyView();
    }

    public void onClick(View view) {
        int mCurrentIndex = this.indexOfTabIndex(view.getId());
        this.mViewPager.setCurrentItem(mCurrentIndex, false);
    }

    private int indexOfTabIndex(int value) {
        for (int i = 0; i < this.mTabSrcId.length; ++i) {
            if (this.mTabSrcId[i] != value) continue;
            return i;
        }
        return 0;
    }

    private void cursorAnim(int curItem) {
        int mCursorX = 0;
        this.mCursorImg.setX((float)(mCursorX + this.mCursorW * curItem));
    }

    private void resetTabColor() {
        for (TextView mTabTv : this.mTabTvs) {
            mTabTv.setTextColor(this.getColorRes(R.color.base_black_37));
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        this.resetTabColor();
        this.mTabTvs[position].setTextColor(this.getColorRes(R.color.base_black_95));
        this.cursorAnim(position);
    }

    public void onPageScrollStateChanged(int state) {
    }
}

