/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.historyfile.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.widget.ExpandableListAdapter;
import android.widget.Toast;
import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.event.IMProxyFileEvent;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.presenter.IMFragmentPresenter;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.historyfile.adapter.HistoryFileAdapterPresenter;
import com.xdja.im.lib.historyfile.command.IHistoryFileListCommand;
import com.xdja.im.lib.historyfile.util.DataSourceFilter;
import com.xdja.im.lib.historyfile.view.ViewHistoryFileListFragment;
import com.xdja.im.lib.historyfile.vu.IHistoryFileListFragmentVu;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.dialog.CustomDialog;
import com.xdja.im.uikit.utils.log.LogUtil;
import dagger.Lazy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import rx.Subscriber;

public class HistoryFileListFragment
extends IMFragmentPresenter<IHistoryFileListCommand, IHistoryFileListFragmentVu>
implements IHistoryFileListCommand,
HistoryFileAdapterPresenter.ItemLongClickListener {
    private String flag;
    private String talkId;
    private int talkType;
    private String title;
    private int tag = -1;
    BusProvider busProvider;
    @Inject
    Lazy<ProxyRepository> proxyRepository;
    private HistoryFileAdapterPresenter mAdapter;
    private Map<HistoryFileCategory, List<TalkMessageBean>> mDatas;

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDatas(Map<HistoryFileCategory, List<TalkMessageBean>> datas) {
        this.mDatas = datas;
    }

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (null == this.useCaseComponent) {
            LogUtil.e("HistoryFileListFragment", "useCaseComponent is null");
            return;
        }
        this.useCaseComponent.inject(this);
        this.busProvider = BusProvider.getInstance();
        this.busProvider.register(this);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.flag = bundle.getString("talkId");
            this.talkId = bundle.getString("talkerId");
            this.talkType = bundle.getInt("chatType", 1);
            this.tag = bundle.getInt("tag");
            if (TextUtils.isEmpty((CharSequence)this.talkId)) {
                return;
            }
        }
        this.mAdapter = new HistoryFileAdapterPresenter((Context)this.getActivity(), this.busProvider, this.mDatas, this.userCache);
        this.useCaseComponent.inject(this.mAdapter);
        this.mAdapter.setItemLongClickListener(this);
        this.mAdapter.setActivity((Activity)this.getActivity());
        this.mAdapter.setListView(((IHistoryFileListFragmentVu)this.getVu()).getListView());
        ((IHistoryFileListFragmentVu)this.getVu()).getListView().setAdapter((ExpandableListAdapter)this.mAdapter);
        if (this.tag == 2) {
            IMProxyFileEvent.HistoryFileEvent historyFileEvent = new IMProxyFileEvent.HistoryFileEvent();
            this.busProvider.post(historyFileEvent);
        }
    }

    public void notifyDataChange() {
        ((IHistoryFileListFragmentVu)this.getVu()).showEmpty(this.mDatas.size() == 0);
        this.mAdapter.notifyDataSetChanged();
    }

    public void updateUIAfterDeleteFiles(List<TalkMessageBean> deleteBeans) {
        for (Map.Entry<HistoryFileCategory, List<TalkMessageBean>> entry : this.mDatas.entrySet()) {
            entry.getValue().removeAll(deleteBeans);
            if (entry.getValue().size() != 0) continue;
            this.mDatas.remove(entry.getKey());
        }
        ((IHistoryFileListFragmentVu)this.getVu()).showEmpty(this.mDatas.size() == 0);
        this.mAdapter.notifyDataSetChanged();
    }

    private void changeNetworkViewState(int flag) {
        if (flag != 0 && this.mDatas.size() > 0) {
            for (Map.Entry<HistoryFileCategory, List<TalkMessageBean>> entry : this.mDatas.entrySet()) {
                for (TalkMessageBean bean : entry.getValue()) {
                    FileInfo fInfo = bean.getFileInfo();
                    if (fInfo.getFileState() != 3) continue;
                    fInfo.setFileState(4);
                    this.mAdapter.clickToDownloadOfOpen(bean);
                }
            }
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void changeNeworkState(IMProxyEvent.NetworkStateEvent event) {
        this.changeNetworkViewState(event.getState());
    }

    @Subscribe
    public void receiveFileProgressUpdateEvent(IMProxyFileEvent.ReceiveFileProgressUpdateEvent event) {
        TalkMessageBean bean = DataSourceFilter.findMessageBeanWithId(this.mDatas, event.getAttachedMsgId());
        if (bean != null) {
            bean.getFileInfo().setFileState(3);
            bean.getFileInfo().setTranslatePercent(event.getPercent());
            this.userCache.putProgress(bean.getId(), event.getPercent());
            this.mAdapter.refreshItem(event.getAttachedMsgId());
        }
    }

    @Subscribe
    public void receiveFilePaused(IMProxyFileEvent.ReceiveFilePausedEvent event) {
        TalkMessageBean bean = DataSourceFilter.findMessageBeanWithId(this.mDatas, event.getAttachedMsgId());
        FileInfo fileInfo = event.getFileInfo();
        LogUtil.d("", "HistoryFile paused:" + fileInfo.getTranslatePercent());
        if (bean != null) {
            bean.getFileInfo().setFileState(4);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void receiveFileFailedEvent(IMProxyFileEvent.ReceiveFileFailedEvent event) {
        TalkMessageBean bean = DataSourceFilter.findMessageBeanWithId(this.mDatas, event.getAttachedMsgId());
        if (bean != null) {
            bean.getFileInfo().setFileState(5);
            this.userCache.removeProgress(bean.getId());
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void receiveFileFinishedEvent(IMProxyFileEvent.ReceiveFileFinishedEvent event) {
        TalkMessageBean bean = DataSourceFilter.findMessageBeanWithId(this.mDatas, event.getAttachedMsgId());
        if (bean != null) {
            LogUtil.d("", "download activity finish:" + event.getAttachedMsgId() + ",state=" + bean.getFileInfo().getFileState());
            bean.getFileInfo().setFileState(2);
            this.userCache.removeProgress(bean.getId());
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private List<TalkMessageBean> getCheckBean() {
        ArrayList<TalkMessageBean> beans = new ArrayList<TalkMessageBean>();
        for (Map.Entry<HistoryFileCategory, List<TalkMessageBean>> entry : this.mDatas.entrySet()) {
            for (TalkMessageBean bean : entry.getValue()) {
                if (!bean.isChecked()) continue;
                beans.add(bean);
            }
        }
        return beans;
    }

    private List<TalkMessageBean> updateDatas() {
        ArrayList<TalkMessageBean> beans = new ArrayList<TalkMessageBean>();
        for (Map.Entry<HistoryFileCategory, List<TalkMessageBean>> entry : this.mDatas.entrySet()) {
            Iterator<TalkMessageBean> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                TalkMessageBean bean = iterator.next();
                if (!bean.isChecked()) continue;
                beans.add(bean);
                iterator.remove();
            }
            if (entry.getValue().size() != 0) continue;
            this.mDatas.remove(entry.getKey());
        }
        return beans;
    }

    @Override
    @NonNull
    protected Class<? extends IHistoryFileListFragmentVu> getVuClass() {
        return ViewHistoryFileListFragment.class;
    }

    @Override
    @NonNull
    protected IHistoryFileListCommand getCommand() {
        return this;
    }

    @Override
    public void downloadFiles() {
        List<TalkMessageBean> downloadBeans = this.getCheckBean();
        if (downloadBeans.size() == 0) {
            Toast.makeText((Context)this.getActivity(), (int)R.string.im_uikit_history_select_file_none, (int)0).show();
            return;
        }
        final ArrayList<FileInfo> downloadFiles = new ArrayList<FileInfo>();
        ArrayList<FileInfo> downloadedFiles = new ArrayList<FileInfo>();
        for (TalkMessageBean bean : downloadBeans) {
            if (DateUtils.isOverdue(bean.getShowTime())) continue;
            downloadFiles.add(bean.getFileInfo());
            if (!HistoryFileUtils.isFileExist(bean.getFileInfo().getFilePath())) continue;
            downloadedFiles.add(bean.getFileInfo());
        }
        if (downloadFiles.size() == 0 && downloadBeans.size() > 0) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.im_uikit_history_select_all_overdue), (int)0).show();
            return;
        }
        if (downloadFiles.size() < downloadBeans.size() && downloadFiles.size() > 0) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.im_uikit_history_select_all_overdue), (int)0).show();
        }
        if (downloadedFiles.size() > 0) {
            downloadFiles.removeAll(downloadedFiles);
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.im_uikit_history_file_downloaded), (int)0).show();
            if (downloadFiles.size() == 0) {
                return;
            }
        }
        ((ProxyRepository)this.proxyRepository.get()).downloadFile(downloadedFiles, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Integer integer) {
                if (integer == 0) {
                    LogUtil.d("", "zhu->\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6");
                    HistoryFileListFragment.this.addDownloadPercentCache(downloadFiles);
                    HistoryFileListFragment.this.mAdapter.notifyDataSetChanged();
                }
            }
        });
    }

    private void addDownloadPercentCache(List<FileInfo> downloadFiles) {
        for (FileInfo fInfo : downloadFiles) {
            this.userCache.putProgress(fInfo.getTalkMessageId(), 0);
            fInfo.setFileState(3);
        }
    }

    @Override
    public void transmitFiles() {
    }

    @Override
    public void removeFiles() {
    }

    public void showRemoveDialog(final List<Long> ids, final Map<Integer, TalkMessageBean> deleteBean) {
        new CustomDialog((Context)this.getActivity(), new CustomDialog.OnCloseListener(){

            @Override
            public void onClick(Dialog dialog, boolean confirm) {
                if (confirm) {
                    ((IHistoryFileListFragmentVu)HistoryFileListFragment.this.getVu()).showCommonProgressDialog(R.string.im_uikit_hisroty_file_delete);
                    ((ProxyRepository)HistoryFileListFragment.this.proxyRepository.get()).deleteMessages(ids, new Subscriber<Integer>(){

                        public void onCompleted() {
                        }

                        public void onError(Throwable e) {
                            ((IHistoryFileListFragmentVu)HistoryFileListFragment.this.getVu()).dismissCommonProgressDialog();
                            LogUtil.d("", "\u6d88\u606f\u5220\u9664\u5931\u8d25");
                        }

                        public void onNext(Integer integer) {
                            ((IHistoryFileListFragmentVu)HistoryFileListFragment.this.getVu()).dismissCommonProgressDialog();
                            if (integer == 0) {
                                LogUtil.d("", "\u6d88\u606f\u5220\u9664\u6210\u529f");
                                HistoryFileListFragment.this.updateUIAfterDeleteFiles(deleteBean);
                            }
                        }
                    });
                }
            }
        }).setNegativeButton(this.getString(R.string.im_uikit_cancel_text)).setPositiveButton(this.getString(R.string.im_uikit_history_file_delete_confirm)).setDialogContent(this.getString(R.string.im_uikit_history_file_delete_message)).setDialogTitle(this.getString(R.string.im_uikit_history_file_delete_hint)).show();
    }

    private void updateUIAfterDeleteFiles(Map<Integer, TalkMessageBean> deleteBean) {
        ArrayList<TalkMessageBean> deleteLists = new ArrayList();
        if (deleteBean != null) {
            ArrayList<Integer> keys = new ArrayList<Integer>(deleteBean.keySet());
            int groupPosition = (Integer)keys.get(0);
            TalkMessageBean bean = deleteBean.get(groupPosition);
            ArrayList<HistoryFileCategory> categories = new ArrayList<HistoryFileCategory>(this.mDatas.keySet());
            Collections.sort(categories);
            HistoryFileCategory cate = (HistoryFileCategory)categories.get(groupPosition);
            List<TalkMessageBean> beans = this.mDatas.get(cate);
            if (beans != null && beans.size() > 0) {
                beans.remove(bean);
                if (beans.size() == 0) {
                    this.mDatas.remove(cate);
                }
            }
            deleteLists.clear();
            deleteLists.add(bean);
        } else {
            deleteLists = this.updateDatas();
        }
        ((IHistoryFileListFragmentVu)this.getVu()).showEmpty(this.mDatas.size() == 0);
        this.mAdapter.notifyDataSetChanged();
        this.onDeleteMessage(deleteLists);
    }

    private int onDeleteMessage(List<TalkMessageBean> talkMessageBeans) {
        try {
            IMProxyMessageEvent.DeleteMessageEvent messageEvent = new IMProxyMessageEvent.DeleteMessageEvent();
            messageEvent.setMsgAccount(talkMessageBeans.get(0).getFrom());
            messageEvent.setTalkMessageBean(talkMessageBeans.get(0));
            this.busProvider.post(messageEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Subscribe
    public void historyRefreshSelectHintEvent(IMProxyMessageEvent.HistoryRefreshSelectHintEvent event) {
        ((IHistoryFileListFragmentVu)this.getVu()).refreshSelectHint(this.getCheckBean().size());
    }

    @Override
    public int getDataSize() {
        return this.mDatas.size();
    }

    @Override
    public void itemLongClick(int groupPosition, TalkMessageBean bean) {
        HashMap<Integer, TalkMessageBean> deleteMap = new HashMap<Integer, TalkMessageBean>();
        deleteMap.put(groupPosition, bean);
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        if (bean != null) {
            deleteIds.add(bean.getId());
            this.showRemoveDialog(deleteIds, deleteMap);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (null != this.busProvider) {
            this.busProvider.unregister(this);
        }
        if (null != this.mAdapter) {
            this.mAdapter.onDestroy();
        }
    }

    public void updateMode(int operateAction) {
        this.mAdapter.updateMode(operateAction);
        ((IHistoryFileListFragmentVu)this.getVu()).showEmpty(this.mDatas.size() == 0);
    }
}

