/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.historyfile.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.event.IMProxyFileEvent;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.presenter.IMActivityPresenter;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.NetworkUtils;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.historyfile.adapter.HistoryFragmentPageAdapter;
import com.xdja.im.lib.historyfile.command.IHistoryFileActivityPresenterCommand;
import com.xdja.im.lib.historyfile.fragment.HistoryFileListFragment;
import com.xdja.im.lib.historyfile.fragment.HistoryPhotoAndVideoFragment;
import com.xdja.im.lib.historyfile.util.HistoryModeUtils;
import com.xdja.im.lib.historyfile.view.ViewHistoryFileActivityPresenter;
import com.xdja.im.lib.historyfile.vu.IHistoryFileActivityPresenterVu;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.dialog.CustomDialog;
import com.xdja.im.uikit.utils.NetworkHelper;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import dagger.Lazy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import rx.Subscriber;

public class HistoryFileActivityPresenter
extends IMActivityPresenter<IHistoryFileActivityPresenterCommand, IHistoryFileActivityPresenterVu>
implements IHistoryFileActivityPresenterCommand {
    private int[] historyTitleRes = new int[]{R.string.im_uikit_video_image, R.string.im_uikit_document, R.string.im_uikit_other};
    private String flag;
    private String talkId;
    private int talkType;
    private String[] titles;
    private List<Fragment> fragments;
    private HistoryFragmentPageAdapter mAdapter;
    private HistoryPhotoAndVideoFragment historyPhotoAndVideoFragment;
    private HistoryFileListFragment docFileListFragment;
    private HistoryFileListFragment otherFileListFragment;
    private List<GridItemBean> photoAndVideoGridDatas = new ArrayList<GridItemBean>();
    private Map<HistoryFileCategory, List<TalkMessageBean>> docDatas = new LinkedHashMap<HistoryFileCategory, List<TalkMessageBean>>();
    private Map<HistoryFileCategory, List<TalkMessageBean>> otherDatas = new LinkedHashMap<HistoryFileCategory, List<TalkMessageBean>>();
    BusProvider busProvider;
    @Inject
    Lazy<ProxyRepository> proxyRepository;
    private AlertDialog operateProgressDialog;
    private List<FileInfo> downloadingFiles = new ArrayList<FileInfo>();
    private boolean refreshing;

    @Override
    public boolean isRefreshing() {
        return this.refreshing;
    }

    @Override
    @NonNull
    protected Class<? extends IHistoryFileActivityPresenterVu> getVuClass() {
        return ViewHistoryFileActivityPresenter.class;
    }

    @Override
    @NonNull
    protected IHistoryFileActivityPresenterCommand getCommand() {
        return this;
    }

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (null == this.userComponent) {
            LogUtil.e("HistoryFileActivityPresenter", "useCaseComponent is null");
            return;
        }
        this.userComponent.inject(this);
        this.busProvider = BusProvider.getInstance();
        this.busProvider.register(this);
        Intent intent = this.getIntent();
        if (intent != null) {
            Bundle bundle = intent.getExtras();
            this.initTitleAndFragments(bundle);
            this.flag = intent.getStringExtra("talkId");
            this.talkId = intent.getStringExtra("talkerId");
            this.talkType = intent.getIntExtra("chatType", 1);
            if (TextUtils.isEmpty((CharSequence)this.flag)) {
                this.finish();
                return;
            }
            this.reSetTitle();
        }
    }

    private void reSetTitle() {
        this.setTitle(R.string.im_uikit_chat_file_history_list);
    }

    @Subscribe
    public void receiveEvent(IMProxyFileEvent.HistoryFileEvent historyFileEvent) {
        this.obtainDataMap();
    }

    @Override
    public void obtainDataMap() {
        if (this.refreshing) {
            return;
        }
        this.refreshing = true;
        ImUiKit.getInstance().getComponent().proxyRepository().getAllHistoryFileInfoWithTalkId(this.flag, 3).subscribe((Subscriber)new Subscriber<Map<HistoryFileCategory, List<TalkMessageBean>>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Map<HistoryFileCategory, List<TalkMessageBean>> dataMaps) {
                HistoryFileActivityPresenter.this.photoAndVideoGridDatas.clear();
                HistoryFileActivityPresenter.this.docDatas.clear();
                HistoryFileActivityPresenter.this.otherDatas.clear();
                for (Map.Entry<HistoryFileCategory, List<TalkMessageBean>> entry : dataMaps.entrySet()) {
                    List<TalkMessageBean> talkMsgs = entry.getValue();
                    LinkedList<TalkMessageBean> filterMsgs1 = new LinkedList<TalkMessageBean>();
                    LinkedList<TalkMessageBean> filterMsgs2 = new LinkedList<TalkMessageBean>();
                    LinkedList<TalkMessageBean> filterMsgs3 = new LinkedList<TalkMessageBean>();
                    for (TalkMessageBean bean : talkMsgs) {
                        FileInfo fileInfo = bean.getFileInfo();
                        if (bean.getMessageState() == 0 || bean.getMessageState() == 1) continue;
                        int fileType = FileUtils.getTypeWithSuffix(fileInfo.getFilePath());
                        if (fileType == 12) {
                            fileType = fileInfo.getFileType();
                        } else if (fileType == 11) {
                            fileType = fileInfo.getFileType();
                        }
                        bean.getFileInfo().setFileType(fileType);
                        if (fileType == 3) {
                            filterMsgs1.add(bean);
                            continue;
                        }
                        if (fileType == 2) {
                            filterMsgs1.add(bean);
                            continue;
                        }
                        if (fileType == 5 || fileType == 9 || fileType == 6 || fileType == 7 || fileType == 8) {
                            filterMsgs2.add(bean);
                            continue;
                        }
                        filterMsgs3.add(bean);
                    }
                    if (filterMsgs1.size() > 0) {
                        GridItemBean<HistoryFileCategory> gridItemBean = new GridItemBean<HistoryFileCategory>();
                        gridItemBean.setValue(entry.getKey());
                        gridItemBean.setChildList(filterMsgs1);
                        gridItemBean.setExpand(false);
                        HistoryFileActivityPresenter.this.photoAndVideoGridDatas.add(gridItemBean);
                    }
                    if (filterMsgs2.size() > 0) {
                        HistoryFileActivityPresenter.this.docDatas.put(entry.getKey(), filterMsgs2);
                    }
                    if (filterMsgs3.size() <= 0) continue;
                    HistoryFileActivityPresenter.this.otherDatas.put(entry.getKey(), filterMsgs3);
                }
                HistoryFileActivityPresenter.this.historyPhotoAndVideoFragment.notifyDataChange();
                HistoryFileActivityPresenter.this.docFileListFragment.notifyDataChange();
                HistoryFileActivityPresenter.this.otherFileListFragment.notifyDataChange();
                HistoryFileActivityPresenter.this.refreshing = false;
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.busProvider != null) {
            this.busProvider.unregister(this);
        }
    }

    private void initTitleAndFragments(Bundle bundle) {
        this.titles = this.changeTitle();
        this.docFileListFragment = new HistoryFileListFragment();
        this.otherFileListFragment = new HistoryFileListFragment();
        this.historyPhotoAndVideoFragment = new HistoryPhotoAndVideoFragment();
        this.historyPhotoAndVideoFragment.setDatas(this.photoAndVideoGridDatas);
        this.docFileListFragment.setDatas(this.docDatas);
        this.otherFileListFragment.setDatas(this.otherDatas);
        this.docFileListFragment.setTitle("doc");
        this.otherFileListFragment.setTitle("other");
        Bundle bundle1 = bundle;
        bundle1.putInt("tag", 0);
        Bundle bundle2 = bundle;
        bundle2.putInt("tag", 1);
        Bundle bundle3 = bundle;
        bundle3.putInt("tag", 2);
        this.historyPhotoAndVideoFragment.setArguments(bundle1);
        this.docFileListFragment.setArguments(bundle2);
        this.otherFileListFragment.setArguments(bundle3);
        this.fragments = new ArrayList<Fragment>();
        this.fragments.add(this.historyPhotoAndVideoFragment);
        this.fragments.add(this.docFileListFragment);
        this.fragments.add(this.otherFileListFragment);
        this.mAdapter = new HistoryFragmentPageAdapter(this.getSupportFragmentManager(), this.titles, this.fragments);
        ((IHistoryFileActivityPresenterVu)this.getVu()).setFragmentAdapter(this.mAdapter);
    }

    private String[] changeTitle() {
        String[] tempTitles = new String[this.historyTitleRes.length];
        for (int i = 0; i < this.historyTitleRes.length; ++i) {
            tempTitles[i] = this.getString(this.historyTitleRes[i]);
        }
        return tempTitles;
    }

    @Override
    public void downloadFiles() {
        List<TalkMessageBean> downloadBeans = HistoryModeUtils.getInstance().getAllSelectFiles();
        if (downloadBeans.size() == 0) {
            new XToast((Context)this).display(this.getString(R.string.im_uikit_history_select_file_none));
            return;
        }
        ArrayList<FileInfo> downloadFiles = new ArrayList<FileInfo>();
        for (TalkMessageBean bean : downloadBeans) {
            FileInfo fileInfo = bean.getFileInfo();
            if (fileInfo instanceof VideoFileInfo) {
                ((VideoFileInfo)fileInfo).setType(3);
            } else if (fileInfo instanceof ImageFileInfo) {
                if (((ImageFileInfo)fileInfo).isOriginal()) {
                    ((ImageFileInfo)fileInfo).setType(3);
                } else {
                    ((ImageFileInfo)fileInfo).setType(2);
                }
            }
            downloadFiles.add(fileInfo);
        }
        this.showDialogDownloadFile(downloadFiles);
    }

    public void showDialogDownloadFile(final List<FileInfo> downloadFiles) {
        if (NetworkHelper.getHelper().networkUseless()) {
            new XToast((Context)this).display(R.string.im_uikit_network_disabled);
            return;
        }
        if (NetworkUtils.obtainCurrentNetworkState((Context)this) == NetworkUtils.MOBILE_NETWORK) {
            CustomDialog dialog = new CustomDialog((Context)this, new CustomDialog.OnCloseListener(){

                @Override
                public void onClick(Dialog dialog, boolean confirm) {
                    if (confirm) {
                        HistoryFileActivityPresenter.this.resumeOrDownloadFiles(downloadFiles);
                    }
                }
            });
            dialog.setDialogTitle(R.string.im_uikit_download_file_title).setDialogContent(R.string.im_uikit_download_file_net_type).setPositiveButton(this.getString(R.string.im_uikit_download_file_btn_continue)).setNegativeButton(this.getString(R.string.im_uikit_download_file_btn_cancel)).show();
        } else {
            this.resumeOrDownloadFiles(downloadFiles);
        }
    }

    private void resumeOrDownloadFiles(final List<FileInfo> downloadFiles) {
        this.downloadingFiles.addAll(downloadFiles);
        this.showOperateProgressDialog(this.getString(R.string.im_uikit_file_downloading), false, true);
        ((IHistoryFileActivityPresenterVu)this.getVu()).setOperateAction(0);
        ((ProxyRepository)this.proxyRepository.get()).downloadFile(downloadFiles, new Subscriber<Integer>(){

            public void onCompleted() {
                LogUtil.d("downloadFile file finished.");
            }

            public void onError(Throwable e) {
                LogUtil.d("ERROR : downloadFile file error.");
            }

            public void onNext(Integer integer) {
                HistoryFileActivityPresenter.this.addDownloadPercentCache(downloadFiles);
                LogUtil.d("downloadFile file start.");
            }
        });
    }

    @Subscribe
    public void NetworkStateChange(IMProxyEvent.NetworkStateEvent event) {
        if (event.getState() != 0 && !this.downloadingFiles.isEmpty()) {
            this.dismissOperateProgressDialog();
            new XToast((Context)this).display(R.string.im_uikit_network_change_pause_download);
            ((IHistoryFileActivityPresenterVu)this.getVu()).refreshUI();
            this.obtainDataMap();
        }
    }

    @Subscribe
    public void receiveFileFinishedEvent(IMProxyFileEvent.ReceiveFileFinishedEvent event) {
        if (this.operateProgressDialog != null && this.operateProgressDialog.isShowing()) {
            Iterator<FileInfo> iterator = this.downloadingFiles.iterator();
            while (iterator.hasNext()) {
                FileInfo fileInfo = iterator.next();
                if (fileInfo.getTalkMessageId() != event.getAttachedMsgId()) continue;
                iterator.remove();
            }
            if (this.downloadingFiles.isEmpty()) {
                this.dismissOperateProgressDialog();
                ((IHistoryFileActivityPresenterVu)this.getVu()).refreshUI();
                this.obtainDataMap();
            }
        }
    }

    @Subscribe
    public void receiveFileFailedEvent(IMProxyFileEvent.ReceiveFileFailedEvent event) {
        if (this.operateProgressDialog != null && this.operateProgressDialog.isShowing()) {
            Iterator<FileInfo> iterator = this.downloadingFiles.iterator();
            while (iterator.hasNext()) {
                FileInfo fileInfo = iterator.next();
                if (fileInfo.getTalkMessageId() != event.getAttachedMsgId()) continue;
                iterator.remove();
            }
            if (this.downloadingFiles.isEmpty()) {
                this.dismissOperateProgressDialog();
                ((IHistoryFileActivityPresenterVu)this.getVu()).refreshUI();
                this.obtainDataMap();
            }
        }
    }

    private void addDownloadPercentCache(List<FileInfo> downloadFiles) {
        for (FileInfo fInfo : downloadFiles) {
            this.userCache.putProgress(fInfo.getTalkMessageId(), 0);
            fInfo.setFileState(3);
        }
    }

    @Override
    public void transmitFiles() {
        List<TalkMessageBean> transmitBeans = HistoryModeUtils.getInstance().getAllSelectFiles();
        if (transmitBeans.size() == 0) {
            new XToast((Context)this).display(this.getString(R.string.im_uikit_history_select_file_none));
            return;
        }
        ArrayList<FileInfo> transmitFiles = new ArrayList<FileInfo>();
        for (TalkMessageBean bean : transmitBeans) {
            FileInfo fileInfo = bean.getFileInfo();
            String rawFilePath = "";
            String filePath = "";
            if (fileInfo instanceof VideoFileInfo) {
                rawFilePath = ((VideoFileInfo)fileInfo).getRawFileInfo().getFilePath();
            } else if (fileInfo instanceof ImageFileInfo) {
                rawFilePath = ((ImageFileInfo)fileInfo).getRawFileInfo().getFilePath();
                filePath = fileInfo.getFilePath();
            } else {
                filePath = fileInfo.getFilePath();
            }
            if (!HistoryFileUtils.isFileExist(rawFilePath) && !HistoryFileUtils.isFileExist(filePath)) continue;
            transmitFiles.add(bean.getFileInfo());
        }
        if (transmitFiles.size() == 0) {
            new XToast((Context)this).display(this.getString(R.string.im_uikit_history_transmit_all_noexist));
            return;
        }
        if (transmitFiles.size() > 0 && transmitFiles.size() < transmitBeans.size()) {
            new XToast((Context)this).display(this.getString(R.string.im_uikit_history_transmit_part_noexist));
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 3) {
            ((IHistoryFileActivityPresenterVu)this.getVu()).setOperateAction(0);
            ((IHistoryFileActivityPresenterVu)this.getVu()).refreshUI();
            this.obtainDataMap();
        }
    }

    @Override
    public void removeFiles() {
        List<TalkMessageBean> deleteBeans = HistoryModeUtils.getInstance().getAllSelectFiles();
        if (deleteBeans.size() == 0) {
            new XToast((Context)this).display(this.getString(R.string.im_uikit_history_select_file_none));
            return;
        }
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (TalkMessageBean bean : deleteBeans) {
            deleteIds.add(bean.getId());
        }
        this.showRemoveDialog(deleteIds, deleteBeans);
    }

    private void showOperateProgressDialog(String msg, boolean isOutsideTouchCancelable, boolean isBackCancelable) {
        this.operateProgressDialog = new AlertDialog.Builder((Context)this).create();
        Window dialogWindow = this.operateProgressDialog.getWindow();
        WindowManager.LayoutParams lp = dialogWindow.getAttributes();
        lp.alpha = 0.5f;
        dialogWindow.setAttributes(lp);
        dialogWindow.setDimAmount(0.0f);
        View view = this.getLayoutInflater().inflate(R.layout.im_uikit_operate_progress_dialog, null);
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.progress);
        int style2 = UniversalUtil.getThemeStyle((Context)this);
        progressBar.setIndeterminateDrawable(this.getResources().getDrawable(style2 == 0 ? R.drawable.im_uikit_circle_progressbar : R.drawable.im_uikit_circle_progressbar_light));
        TextView messageView = (TextView)view.findViewById(R.id.dialog_message);
        messageView.setText((CharSequence)msg);
        this.operateProgressDialog.setView(view);
        this.operateProgressDialog.setCanceledOnTouchOutside(isOutsideTouchCancelable);
        this.operateProgressDialog.setCancelable(isBackCancelable);
        this.operateProgressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                ((IHistoryFileActivityPresenterVu)HistoryFileActivityPresenter.this.getVu()).refreshUI();
                HistoryFileActivityPresenter.this.obtainDataMap();
            }
        });
        this.operateProgressDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (!HistoryFileActivityPresenter.this.downloadingFiles.isEmpty()) {
                    HistoryFileActivityPresenter.this.pauseDownloadFile();
                }
                HistoryFileActivityPresenter.this.downloadingFiles.clear();
            }
        });
        if (!this.operateProgressDialog.isShowing()) {
            this.operateProgressDialog.show();
        }
    }

    private void pauseDownloadFile() {
        for (final FileInfo fileInfo : this.downloadingFiles) {
            fileInfo.setFileState(4);
            ((ProxyRepository)this.proxyRepository.get()).pauseFileReceiving(fileInfo, new Subscriber<Integer>(){

                public void onCompleted() {
                    LogUtil.d("Pause downloadFile file finished.");
                }

                public void onError(Throwable e) {
                    LogUtil.d("ERROR : pause downloadFile file error.");
                }

                public void onNext(Integer integer) {
                    if (integer == 0) {
                        LogUtil.d("", "-->\u6682\u505c\u4e0b\u8f7d\u6587\u4ef6 fileInfo =" + fileInfo);
                    }
                }
            });
        }
    }

    private void dismissOperateProgressDialog() {
        if (this.operateProgressDialog != null && this.operateProgressDialog.isShowing()) {
            this.operateProgressDialog.dismiss();
            this.operateProgressDialog = null;
        }
    }

    public void showRemoveDialog(final List<Long> ids, final List<TalkMessageBean> deleteBeans) {
        new CustomDialog((Context)this, new CustomDialog.OnCloseListener(){

            @Override
            public void onClick(Dialog dialog, boolean confirm) {
                if (confirm) {
                    HistoryFileActivityPresenter.this.deleteMsg(ids, deleteBeans);
                }
            }
        }).setDialogTitle(this.getString(R.string.im_uikit_history_file_delete_hint)).setDialogContent(this.getString(R.string.im_uikit_history_file_delete_message)).setNegativeButton(this.getString(R.string.im_uikit_download_file_btn_cancel)).setPositiveButton(this.getString(R.string.im_uikit_history_file_delete_confirm)).show();
    }

    private void updateUIAfterDeleteFiles(List<TalkMessageBean> deleteBeans) {
        HistoryModeUtils.getInstance().clearCache();
        for (Fragment fragment : this.fragments) {
            if (fragment instanceof HistoryPhotoAndVideoFragment) {
                ((HistoryPhotoAndVideoFragment)fragment).updateUIAfterDeleteFiles(deleteBeans);
            }
            if (!(fragment instanceof HistoryFileListFragment)) continue;
            ((HistoryFileListFragment)fragment).updateUIAfterDeleteFiles(deleteBeans);
        }
        if (deleteBeans != null && deleteBeans.size() > 0) {
            if (deleteBeans.size() > 1) {
                for (int i = 0; i < deleteBeans.size(); ++i) {
                    IMProxyMessageEvent.DeleteMessageEvent event = new IMProxyMessageEvent.DeleteMessageEvent();
                    event.setTalkMessageBean(deleteBeans.get(i));
                    event.setMsgAccount(deleteBeans.get(i).getFrom());
                    this.busProvider.post(event);
                }
            } else {
                IMProxyMessageEvent.DeleteMessageEvent event = new IMProxyMessageEvent.DeleteMessageEvent();
                event.setTalkMessageBean(deleteBeans.get(0));
                event.setMsgAccount(deleteBeans.get(0).getFrom());
                this.busProvider.post(event);
            }
        }
    }

    private void deleteMsg(List<Long> ids, final List<TalkMessageBean> deleteBeans) {
        this.showOperateProgressDialog(this.getString(R.string.im_uikit_is_deleting), false, true);
        ((ProxyRepository)this.proxyRepository.get()).deleteMessages(ids, new Subscriber<Integer>(){

            public void onCompleted() {
                LogUtil.d("Delete message successfully. 16842960");
            }

            public void onError(Throwable e) {
                HistoryFileActivityPresenter.this.dismissOperateProgressDialog();
                ((IHistoryFileActivityPresenterVu)HistoryFileActivityPresenter.this.getVu()).setOperateAction(0);
                ((IHistoryFileActivityPresenterVu)HistoryFileActivityPresenter.this.getVu()).refreshUI();
                LogUtil.d("", "\u6d88\u606f\u5220\u9664\u5931\u8d25");
            }

            public void onNext(Integer integer) {
                if (integer == 0) {
                    LogUtil.d("", "\u6d88\u606f\u5220\u9664\u6210\u529f");
                    HistoryFileActivityPresenter.this.updateUIAfterDeleteFiles(deleteBeans);
                    HistoryFileActivityPresenter.this.dismissOperateProgressDialog();
                    ((IHistoryFileActivityPresenterVu)HistoryFileActivityPresenter.this.getVu()).setOperateAction(0);
                    ((IHistoryFileActivityPresenterVu)HistoryFileActivityPresenter.this.getVu()).refreshUI();
                }
            }
        });
    }

    @Override
    public void updateMode(int operateAction) {
        for (Fragment fragment : this.fragments) {
            if (fragment instanceof HistoryFileListFragment) {
                ((HistoryFileListFragment)fragment).updateMode(operateAction);
                continue;
            }
            if (!(fragment instanceof HistoryPhotoAndVideoFragment)) continue;
            ((HistoryPhotoAndVideoFragment)fragment).updateMode(operateAction);
        }
    }

    @Subscribe
    public void historyRefreshSelectHintEvent(IMProxyMessageEvent.HistoryRefreshSelectHintEvent event) {
        List<TalkMessageBean> checkLists = HistoryModeUtils.getInstance().getAllSelectFiles();
        ((IHistoryFileActivityPresenterVu)this.getVu()).refreshSelectHint(checkLists != null ? checkLists.size() : 0);
    }

    @Subscribe
    public void onRefreshRecallMessage(IMProxyEvent.RecallMessageEvent event) {
        if (event == null || event.getTalkMessageBean() == null) {
            return;
        }
        this.obtainDataMap();
    }
}

