/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.share;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.utils.PermissionUtils;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.model.ShareInfo;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.filemanage.util.ModelGenerator;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.share.adapter.ShareSessionListAdapter;
import com.xdja.im.lib.share.model.IntentBean;
import com.xdja.im.lib.share.model.ShareBean;
import com.xdja.im.lib.share.model.WebPageInfo;
import com.xdja.im.lib.share.presenter.ShareSessionListPresenter;
import com.xdja.im.lib.share.util.ShareUtils;
import com.xdja.im.lib.share.view.ShareViewSessionList;
import com.xdja.im.lib.share.view.vu.ShareViewSessionListVu;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ShareImBaseActivity;
import com.xdja.im.uikit.utils.DataConvertUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import dagger.Lazy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class ShareSessionListActivity
extends ShareImBaseActivity<ShareSessionListPresenter, ShareViewSessionListVu>
implements ShareSessionListPresenter {
    private static final String TAG = ShareSessionListActivity.class.getSimpleName();
    @Inject
    Lazy<ProxyRepository> proxyRepository;
    private ShareSessionListAdapter adapter;
    private Intent intent;
    private BusProvider busProvider;
    private List<TalkSessionBean> mSessionList = new ArrayList<TalkSessionBean>();
    private int mTalkType = 0;
    private String mType;

    @Override
    @SuppressLint(value={"NewApi"})
    protected void preBindView(Bundle savedInstanceState) {
        super.preBindView(savedInstanceState);
        this.intent = this.getIntent();
        this.mType = IMFileUtils.filterFileType(this.intent);
    }

    @Override
    protected void onBindView(@Nullable Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (this.mComponent == null) {
            return;
        }
        this.mComponent.inject(this);
        this.busProvider = BusProvider.getInstance();
        this.busProvider.register(this);
        this.adapter = new ShareSessionListAdapter(this.mSessionList, this);
        ((ShareViewSessionListVu)this.getVu()).setAdapter(this.adapter);
        ((ShareViewSessionListVu)this.getVu()).setToolBarVisibility(0);
        ((ShareViewSessionListVu)this.getVu()).setTitle("\u9009\u62e9");
        ((ShareViewSessionListVu)this.getVu()).setTitleColor(R.color.im_uiKit_share_title_color);
        ((ShareViewSessionListVu)this.getVu()).setToolBarAddVisibility(4);
        this.startLoadSessionData();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.intent = intent;
    }

    protected void onResume() {
        super.onResume();
        this.requestPermissions((Activity)this);
        ((ShareViewSessionListVu)this.getVu()).clearShareSearch();
    }

    public void requestPermissions(Activity context) {
        if (!PermissionUtils.hasSelfPermissions((Context)context, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
            PermissionUtils.requestPermissions(context, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
        }
    }

    @Override
    @NonNull
    protected Class<? extends ShareViewSessionListVu> getVuClass() {
        return ShareViewSessionList.class;
    }

    @Override
    @NonNull
    protected ShareSessionListPresenter getPresenter() {
        return this;
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    @Override
    public void onSearchChanged(String searchKey) {
        IMUiKitProxyImpl.getInstance().callSessionSearch((Context)this.getActivity(), searchKey, 1003, this.intent.getAction());
    }

    @Override
    public void onCreateSessionClick() {
        IMUiKitProxyImpl.getInstance().callSessionContact((Context)this.getActivity(), 1001, this.intent.getAction());
    }

    @Override
    public void onSelectGroup() {
        IMUiKitProxyImpl.getInstance().callSessionContact((Context)this.getActivity(), 1002, this.intent.getAction());
    }

    @Override
    public void onListItemClick(TalkSessionBean item) {
        if (item != null) {
            ((ShareViewSessionListVu)this.getVu()).showDialog(this.intent, item);
        }
    }

    @Override
    public void onDialogRequestForwardSend(List<ShareBean> list, final Intent intent, final String liuYan) {
        Observable.from(list).filter((Func1)new Func1<ShareBean, Boolean>(){

            public Boolean call(ShareBean shareBean) {
                if (!TextUtils.isEmpty((CharSequence)liuYan)) {
                    ShareSessionListActivity.this.sendTextMessage(liuYan, shareBean.getAccount(), shareBean.getType());
                }
                return true;
            }
        }).map((Func1)new Func1<ShareBean, Boolean>(){

            public Boolean call(ShareBean shareBean) {
                return ShareSessionListActivity.this.sendForwardMessage(shareBean, intent);
            }
        }).subscribe((Subscriber)new Subscriber<Boolean>(){

            public void onCompleted() {
                if (!intent.getAction().equals("android.intent.action.FORWARD")) {
                    ((ShareViewSessionListVu)ShareSessionListActivity.this.getVu()).showSimpleDialog();
                } else {
                    ((ShareViewSessionListVu)ShareSessionListActivity.this.getVu()).showFwordSimpleDialog();
                }
                IMProxyMessageEvent.RefreshMessageListEvent event = new IMProxyMessageEvent.RefreshMessageListEvent();
                event.setNeedClearInput(true);
                ShareSessionListActivity.this.busProvider.post(event);
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(Boolean b) {
                LogUtil.d("\u8f6c\u53d1\u5b8c\u6210");
            }
        });
    }

    private boolean sendForwardMessage(ShareBean shareBean, Intent intent) {
        int msgType = intent.getIntExtra("FORWARD_MSG_TYPE", 0);
        switch (msgType) {
            case 0: 
            case 14: {
                String content = intent.getExtras().getString("android.intent.extra.TEXT");
                this.sendTextMessage(content, shareBean.getAccount(), shareBean.getType());
                break;
            }
            case 3: {
                ImageFileInfo imageFileInfo = (ImageFileInfo)intent.getExtras().getSerializable("FORWARD_FILE");
                ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
                if (!imageFileInfo.isOriginal()) {
                    imageFileInfo.setFileType(0);
                }
                fileInfos.add(imageFileInfo);
                this.sendFileMessage(fileInfos, shareBean.getAccount(), shareBean.getType());
                break;
            }
            case 2: 
            case 4: {
                FileInfo fileInfo2 = (FileInfo)intent.getExtras().getSerializable("FORWARD_FILE");
                ArrayList<FileInfo> fileInfos2 = new ArrayList<FileInfo>();
                fileInfos2.add(fileInfo2);
                this.sendFileMessage(fileInfos2, shareBean.getAccount(), shareBean.getType());
                break;
            }
            case 5: {
                WebPageInfo webInfo = (WebPageInfo)intent.getSerializableExtra("FORWARD_WEB");
                if (webInfo == null) break;
                this.sendWebMessage(webInfo, shareBean.getAccount(), shareBean.getType());
            }
        }
        return true;
    }

    @Override
    public void onDialogRequestSend(List<ShareBean> shareBeanList, final IntentBean intentBean, final String dialogContent) {
        Observable.from(shareBeanList).filter((Func1)new Func1<ShareBean, Boolean>(){

            public Boolean call(ShareBean shareBean) {
                if (!TextUtils.isEmpty((CharSequence)intentBean.getContent()) && ShareSessionListActivity.this.mType != "web/") {
                    ShareSessionListActivity.this.sendTextMessage(intentBean.getContent(), shareBean.getAccount(), shareBean.getType());
                }
                return true;
            }
        }).filter((Func1)new Func1<ShareBean, Boolean>(){

            public Boolean call(ShareBean shareBean) {
                if (!TextUtils.isEmpty((CharSequence)intentBean.getContent()) && ShareSessionListActivity.this.mType == "web/") {
                    WebPageInfo webPageInfo = ShareSessionListActivity.this.dealWebPageInfo(intentBean);
                    ShareSessionListActivity.this.sendWebMessage(webPageInfo, shareBean.getAccount(), shareBean.getType());
                }
                return true;
            }
        }).filter((Func1)new Func1<ShareBean, Boolean>(){

            public Boolean call(ShareBean shareBean) {
                if (!TextUtils.isEmpty((CharSequence)dialogContent)) {
                    ShareSessionListActivity.this.sendTextMessage(dialogContent, shareBean.getAccount(), shareBean.getType());
                }
                return true;
            }
        }).toList().map((Func1)new Func1<List<ShareBean>, ShareBean>(){

            public ShareBean call(List<ShareBean> shareBeans) {
                if (intentBean.getUriArrayList() != null && intentBean.getUriArrayList().size() > 0) {
                    ShareSessionListActivity.this.sendIntentFile(shareBeans, intentBean);
                }
                return null;
            }
        }).subscribe((Subscriber)new Subscriber<ShareBean>(){

            public void onCompleted() {
                if (!intentBean.getAction().equals("android.intent.action.FORWARD")) {
                    ((ShareViewSessionListVu)ShareSessionListActivity.this.getVu()).showSimpleDialog();
                } else {
                    ((ShareViewSessionListVu)ShareSessionListActivity.this.getVu()).showFwordSimpleDialog();
                }
                IMProxyMessageEvent.RefreshMessageListEvent event = new IMProxyMessageEvent.RefreshMessageListEvent();
                event.setNeedClearInput(true);
                ShareSessionListActivity.this.busProvider.post(event);
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(ShareBean shareBean) {
                LogUtil.d("\u5206\u4eab\u6210\u529f");
            }
        });
    }

    private WebPageInfo dealWebPageInfo(IntentBean intentBean) {
        FileItem info;
        ShareInfo shareInfo = ShareUtils.getShareInfo(this.intent);
        WebPageInfo webPageInfo = new WebPageInfo();
        webPageInfo.setDescription(shareInfo.getContent());
        webPageInfo.setWebUri(shareInfo.getWebUrl());
        webPageInfo.setTitle(shareInfo.getTitle());
        webPageInfo.setAction(intentBean.getAction());
        webPageInfo.setType(intentBean.getType());
        if (!TextUtils.isEmpty((CharSequence)shareInfo.getFileUri()) && (info = IMFileUtils.queryLocalFiles(this.getContext(), Uri.parse((String)shareInfo.getFileUri()))) != null) {
            webPageInfo.setFilePath(info.getFilePath());
            webPageInfo.setFileName(info.getFileName());
            webPageInfo.setFileSize(info.getFileSize());
            String name = info.getFileName();
            String suffix = ToolUtil.getLastString(name, ".");
            if (!TextUtils.isEmpty((CharSequence)suffix)) {
                webPageInfo.setSuffix(suffix);
            }
        }
        return webPageInfo;
    }

    private void sendIntentFile(final List<ShareBean> shareBeans, final IntentBean intentBean) {
        Observable.from(intentBean.getUriArrayList()).subscribeOn(Schedulers.io()).map((Func1)new Func1<String, FileInfo>(){

            public FileInfo call(String s) {
                if (!TextUtils.isEmpty((CharSequence)intentBean.getType()) && intentBean.getType().startsWith("image/")) {
                    ImageFileInfo fileInfo = null;
                    String path = IMFileUtils.getImagePath(ShareSessionListActivity.this.getContext(), Uri.parse((String)Uri.decode((String)s)).toString());
                    if (!TextUtils.isEmpty((CharSequence)path)) {
                        ImageFileInfo imageFileInfo = new ImageFileInfo();
                        imageFileInfo.setFilePath(path);
                        fileInfo = ModelGenerator.createContentImageFile(path, ImUiKit.getInstance().getComponent().accountCache().get().getAccount());
                    }
                    return fileInfo;
                }
                FileItem info = IMFileUtils.queryLocalFiles(ShareSessionListActivity.this.getContext(), Uri.parse((String)Uri.decode((String)s)));
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFilePath(info.getFilePath());
                fileInfo.setFileName(info.getFileName());
                fileInfo.setFileSize(info.getFileSize());
                String name = info.getFileName();
                String suffix = ToolUtil.getLastString(name, ".");
                if (!TextUtils.isEmpty((CharSequence)suffix)) {
                    fileInfo.setSuffix(suffix);
                }
                fileInfo.setFileType(info.getFileType());
                boolean isVideo = IMFileUtils.isVideoFileType(name);
                boolean isImage = IMFileUtils.isImageFileType(name);
                if (isImage) {
                    fileInfo = DataConvertUtils.mapImagePicFileInfo(fileInfo);
                }
                if (isVideo && (fileInfo = DataConvertUtils.mapVideoFileInfo(fileInfo)) != null) {
                    fileInfo.setFileType(2);
                }
                return fileInfo;
            }
        }).toList().subscribeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<List<FileInfo>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(List<FileInfo> fileInfos) {
                if (fileInfos != null) {
                    for (ShareBean shareBean : shareBeans) {
                        ShareSessionListActivity.this.sendFileMessage(fileInfos, shareBean.getAccount(), shareBean.getType());
                    }
                }
            }
        });
    }

    @Override
    public void onDialogCancleSend() {
    }

    @Override
    public void onTipsDialogTrueClick() {
        IMUiKitProxyImpl.getInstance().shareOverCallback((Context)this.getActivity());
        this.finish();
    }

    @Override
    public void onTipsDialogClick() {
        this.finish();
    }

    @Override
    public boolean sendTextMessage(String message, String sendTo, int type) {
        if (this.proxyRepository == null || this.proxyRepository.get() == null) {
            return false;
        }
        ((ProxyRepository)this.proxyRepository.get()).sendTextMessage(message, sendTo, false, type == 2, new Subscriber<TalkMessageBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(TalkMessageBean talkMessageBean) {
            }
        });
        return false;
    }

    @Override
    public void sendFileMessage(List<FileInfo> fileList, String sendTo, int type) {
        if (this.proxyRepository == null || this.proxyRepository.get() == null) {
            return;
        }
        ((ProxyRepository)this.proxyRepository.get()).sendFileMessage(sendTo, false, type == 2, fileList, new Subscriber<TalkMessageBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(TalkMessageBean talkMessageBean) {
            }
        });
    }

    private void startLoadSessionData() {
        ((ShareViewSessionListVu)this.getVu()).setProgressBarVisibility(0);
        if (this.proxyRepository == null || this.proxyRepository.get() == null) {
            return;
        }
        ((ProxyRepository)this.proxyRepository.get()).getSessionListBeans("", 0, this.mTalkType, new Subscriber<List<TalkSessionBean>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                ((ShareViewSessionListVu)ShareSessionListActivity.this.getVu()).setProgressBarVisibility(8);
                LogUtil.e("ERROR: Load session data error. " + e.getMessage());
            }

            public void onNext(List<TalkSessionBean> sessionBeanList) {
                LogUtil.d("Load session data finished.");
                if (sessionBeanList != null && sessionBeanList.size() > 0) {
                    ShareSessionListActivity.this.mSessionList.clear();
                    ShareSessionListActivity.this.removeExists(sessionBeanList);
                    ShareSessionListActivity.this.mSessionList.addAll(sessionBeanList);
                    ShareSessionListActivity.this.adapter.notifyDataSetChanged();
                    ((ShareViewSessionListVu)ShareSessionListActivity.this.getVu()).setShareSessionEmptyVisibility(8);
                } else {
                    ((ShareViewSessionListVu)ShareSessionListActivity.this.getVu()).setShareSessionEmptyVisibility(0);
                }
                ((ShareViewSessionListVu)ShareSessionListActivity.this.getVu()).setProgressBarVisibility(8);
            }
        });
    }

    @Override
    protected void onDestroy() {
        if (this.busProvider != null) {
            this.busProvider.unregister(this);
        }
        super.onDestroy();
    }

    private void removeExists(List<TalkSessionBean> beans) {
        Iterator<TalkSessionBean> iterator = beans.iterator();
        while (iterator.hasNext()) {
            TalkSessionBean bean = iterator.next();
            int index = beans.indexOf(bean);
            if (index <= -1 || bean == beans.get(index)) continue;
            iterator.remove();
        }
    }

    @Subscribe
    public void onShareContactRefreshEvent(IMProxyMessageEvent.ShareContactRefreshEvent event) {
        int type = event.getType();
        List<ShareBean> list = event.getList();
        switch (type) {
            case 1001: 
            case 1002: {
                break;
            }
        }
        ((ShareViewSessionListVu)this.getVu()).showMultiContactDialog(this.intent, list);
    }

    @Override
    public boolean sendWebMessage(WebPageInfo webPageInfo, String sendTo, int type) {
        if (this.proxyRepository == null || this.proxyRepository.get() == null) {
            return false;
        }
        ((ProxyRepository)this.proxyRepository.get()).sendWebMessage(sendTo, false, type == 2, webPageInfo, new Subscriber<TalkMessageBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(TalkMessageBean bean) {
                ShareSessionListActivity.this.showToast("\u6587\u4ef6\u53d1\u9001\u6210\u529f");
            }
        });
        return false;
    }
}

