/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.adapter;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.ClipboardManager;
import android.text.TextUtils;
import android.view.View;
import android.widget.ListView;
import android.widget.Toast;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.base.frame.presenter.BaseItemAdapterPresenter;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.SystemHelper;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.core.model.message.file.VoiceFileInfo;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.lib.audio.manager.TelphoneState;
import com.xdja.im.lib.share.model.WebPageInfo;
import com.xdja.im.lib.share.util.ShareUtils;
import com.xdja.im.uikit.IntentParam;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.activity.FileDownloadActivity;
import com.xdja.im.uikit.ui.activity.FilePreviewActivity;
import com.xdja.im.uikit.ui.dialog.CustomDialog;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.presenter.ChatListPresenter;
import com.xdja.im.uikit.ui.view.ViewCustomRecItem;
import com.xdja.im.uikit.ui.view.ViewCustomSendItem;
import com.xdja.im.uikit.ui.view.ViewDefaultSendItem;
import com.xdja.im.uikit.ui.view.ViewNotifyItem;
import com.xdja.im.uikit.ui.view.ViewRecvFileItem;
import com.xdja.im.uikit.ui.view.ViewRecvImageItem;
import com.xdja.im.uikit.ui.view.ViewRecvLocationItem;
import com.xdja.im.uikit.ui.view.ViewRecvTextItem;
import com.xdja.im.uikit.ui.view.ViewRecvVideoItem;
import com.xdja.im.uikit.ui.view.ViewRecvVoiceItem;
import com.xdja.im.uikit.ui.view.ViewRecvWebItem;
import com.xdja.im.uikit.ui.view.ViewSendFileItem;
import com.xdja.im.uikit.ui.view.ViewSendImageItem;
import com.xdja.im.uikit.ui.view.ViewSendLocationItem;
import com.xdja.im.uikit.ui.view.ViewSendTextItem;
import com.xdja.im.uikit.ui.view.ViewSendVideoItem;
import com.xdja.im.uikit.ui.view.ViewSendVoiceItem;
import com.xdja.im.uikit.ui.view.ViewSendWebItem;
import com.xdja.im.uikit.utils.SpUtils;
import com.xdja.im.uikit.utils.audio.AudioPlayerManagerProxy;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.List;
import rx.Subscriber;

public class ChatListAdapter
extends BaseItemAdapterPresenter<ChatListAdapterPresenter, TalkMessageBean>
implements ChatListAdapterPresenter {
    private ProxyRepository proxyRepository;
    private ChatListPresenter mPresenter;
    private ListView listView;
    private final List<TalkMessageBean> mDataSource;
    private List<Class<? extends AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean>>> vuClasses;

    public ChatListAdapter(ChatListPresenter presenter, List<TalkMessageBean> dataSource, ListView listView, ProxyRepository proxyRepository) {
        this.mPresenter = presenter;
        this.mDataSource = dataSource;
        this.listView = listView;
        this.proxyRepository = proxyRepository;
    }

    @Override
    protected Activity getActivity() {
        return this.mPresenter.getActivity();
    }

    @Override
    protected ChatListAdapterPresenter getPresenter() {
        return this;
    }

    @Override
    protected TalkMessageBean getDataSource(int position) {
        return this.mDataSource == null ? null : this.mDataSource.get(position);
    }

    public int getCount() {
        return this.mDataSource == null ? 0 : this.mDataSource.size();
    }

    public Object getItem(int position) {
        return this.mDataSource == null ? null : this.mDataSource.get(position);
    }

    public long getItemId(int position) {
        return this.mDataSource != null ? this.mDataSource.get(position).getId() : 0L;
    }

    @Override
    protected List<Class<? extends AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean>>> getVuClasses() {
        if (this.vuClasses == null) {
            this.vuClasses = new ArrayList<Class<? extends AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean>>>();
            this.vuClasses.add(ViewSendTextItem.class);
            this.vuClasses.add(ViewRecvTextItem.class);
            this.vuClasses.add(ViewSendVoiceItem.class);
            this.vuClasses.add(ViewRecvVoiceItem.class);
            this.vuClasses.add(ViewSendImageItem.class);
            this.vuClasses.add(ViewRecvImageItem.class);
            this.vuClasses.add(ViewSendVideoItem.class);
            this.vuClasses.add(ViewRecvVideoItem.class);
            this.vuClasses.add(ViewSendFileItem.class);
            this.vuClasses.add(ViewRecvFileItem.class);
            this.vuClasses.add(ViewSendWebItem.class);
            this.vuClasses.add(ViewRecvWebItem.class);
            this.vuClasses.add(ViewSendLocationItem.class);
            this.vuClasses.add(ViewRecvLocationItem.class);
            this.vuClasses.add(ViewNotifyItem.class);
            this.vuClasses.add(ViewCustomSendItem.class);
            this.vuClasses.add(ViewDefaultSendItem.class);
            this.vuClasses.add(ViewCustomRecItem.class);
        }
        return this.vuClasses;
    }

    @Override
    @NonNull
    protected Class<? extends AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean>> getVuClassByViewType(int itemViewType) {
        Class<? extends AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean>> vuCls = null;
        switch (itemViewType) {
            case 0: {
                vuCls = this.getVuClasses().get(0);
                break;
            }
            case 1: {
                vuCls = this.getVuClasses().get(1);
                break;
            }
            case 2: {
                vuCls = this.getVuClasses().get(2);
                break;
            }
            case 3: {
                vuCls = this.getVuClasses().get(3);
                break;
            }
            case 4: {
                vuCls = this.getVuClasses().get(4);
                break;
            }
            case 5: {
                vuCls = this.getVuClasses().get(5);
                break;
            }
            case 6: {
                vuCls = this.getVuClasses().get(6);
                break;
            }
            case 7: {
                vuCls = this.getVuClasses().get(7);
                break;
            }
            case 8: {
                vuCls = this.getVuClasses().get(8);
                break;
            }
            case 9: {
                vuCls = this.getVuClasses().get(9);
                break;
            }
            case 10: {
                vuCls = this.getVuClasses().get(10);
                break;
            }
            case 11: {
                vuCls = this.getVuClasses().get(11);
                break;
            }
            case 12: {
                vuCls = this.getVuClasses().get(12);
                break;
            }
            case 13: {
                vuCls = this.getVuClasses().get(13);
                break;
            }
            case 14: {
                vuCls = this.getVuClasses().get(14);
                break;
            }
            case 15: {
                vuCls = this.getVuClasses().get(15);
                break;
            }
            case 16: {
                vuCls = this.getVuClasses().get(16);
                break;
            }
            case 17: {
                vuCls = this.getVuClasses().get(17);
            }
        }
        return vuCls;
    }

    public int getViewTypeCount() {
        return this.getVuClasses() != null ? this.getVuClasses().size() : 0;
    }

    public int getItemViewType(int position) {
        int chatDetailType;
        TalkMessageBean talkMessageBean = this.mDataSource.get(position);
        if (talkMessageBean == null) {
            LogUtil.e("Item viewType data is null.");
            return 16;
        }
        switch (talkMessageBean.getMessageType()) {
            case 14: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 0;
                    break;
                }
                chatDetailType = 1;
                break;
            }
            case 0: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 0;
                    break;
                }
                chatDetailType = 1;
                break;
            }
            case 1: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 2;
                    break;
                }
                chatDetailType = 3;
                break;
            }
            case 3: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 4;
                    break;
                }
                chatDetailType = 5;
                break;
            }
            case 2: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 6;
                    break;
                }
                chatDetailType = 7;
                break;
            }
            case 4: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 8;
                    break;
                }
                chatDetailType = 9;
                break;
            }
            case 5: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 10;
                    break;
                }
                chatDetailType = 11;
                break;
            }
            case 6: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 12;
                    break;
                }
                chatDetailType = 13;
                break;
            }
            case 101: {
                chatDetailType = 14;
                break;
            }
            case 102: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 15;
                    break;
                }
                chatDetailType = 17;
                break;
            }
            default: {
                chatDetailType = 16;
            }
        }
        return chatDetailType;
    }

    @Override
    public void reSendMessage(final int position) {
        final TalkMessageBean messageBean = (TalkMessageBean)this.getItem(position);
        if (messageBean == null) {
            LogUtil.e("ERROR: reSend message, but bean is null." + position);
            return;
        }
        this.proxyRepository.reSendMessage(messageBean, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("Resend message error, " + e.getMessage());
            }

            public void onNext(Integer messageId) {
                LogUtil.d("Resend message successfully, " + messageBean.toString());
                messageBean.setMessageState(1);
                ChatListAdapter.this.mDataSource.set(position, messageBean);
                ChatListAdapter.this.updateItem(position, messageBean);
            }
        });
    }

    @Override
    public void deleteItem(int position) {
        final TalkMessageBean messageBean = (TalkMessageBean)this.getItem(position);
        if (messageBean != null) {
            final long id2 = messageBean.getId();
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(id2);
            LogUtil.d("Start delete message " + id2);
            this.proxyRepository.deleteMessages(ids, new Subscriber<Integer>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    LogUtil.e("Delete message error, " + e.getMessage());
                    CommonTool.showToast(R.string.im_uikit_delete_msg_failed);
                }

                public void onNext(Integer integer) {
                    LogUtil.d("Delete message id " + id2 + ", result:" + integer);
                    ChatListAdapter.this.postDeleteMessageEvent(messageBean);
                }
            });
        }
    }

    @Override
    public void recallMessage(int position) {
        TalkMessageBean messageBean = (TalkMessageBean)this.getItem(position);
        if (messageBean == null) {
            LogUtil.e("ERROR: recall message, but bean is null." + position);
            return;
        }
        if (!SpUtils.getInstance().getBoolean("recall_msg")) {
            this.showDialog(R.string.im_uikit_first_use_recall, true, messageBean);
        } else {
            this.recallMsg(messageBean);
        }
    }

    private void recallMsg(TalkMessageBean talkMessageBean) {
        this.proxyRepository.recallMessages(talkMessageBean.getId(), 0, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: recall message failed." + e.getMessage());
            }

            public void onNext(Integer integer) {
                LogUtil.d("message is already recalled.");
                if (integer != null && integer == -104) {
                    ChatListAdapter.this.showDialog(R.string.im_uikit_not_recall_two_minutes, false, null);
                }
            }
        });
    }

    @Override
    public void copyMessage(int position) {
        TalkMessageBean messageBean = (TalkMessageBean)this.getItem(position);
        if (messageBean == null) {
            LogUtil.e("ERROR: copy message, but bean is null." + position);
            return;
        }
        if (messageBean.getMessageType() == 0 || messageBean.getMessageType() == 14) {
            ClipboardManager cmb = (ClipboardManager)this.getActivity().getSystemService("clipboard");
            if (!TextUtils.isEmpty((CharSequence)messageBean.getContent())) {
                cmb.setText((CharSequence)messageBean.getContent());
            }
        }
    }

    @Override
    public void forwardMessage(int position) {
        Intent intent = ShareUtils.buildForwardIntent(this.getActivity(), this.getTalkMessage(position));
        if (intent == null) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)"\u8bf7\u5148\u6253\u5f00\u6216\u4e0b\u8f7d\u6587\u4ef6", (int)0).show();
        } else {
            this.getActivity().startActivity(intent);
        }
    }

    @Override
    public void updateItem(int position, TalkMessageBean talkMessageBean) {
        try {
            View view;
            int firstVisPosition = this.listView.getFirstVisiblePosition();
            int lastVisPosition = this.listView.getLastVisiblePosition();
            if (position < firstVisPosition - 1 || position > lastVisPosition) {
                if (this.getDataSource(position).getMessageType() == 3) {
                    ImageFileInfo imageFileInfo = (ImageFileInfo)this.getDataSource(position).getFileInfo();
                    if (imageFileInfo != null && !"gif".equalsIgnoreCase(imageFileInfo.getSuffix())) {
                        return;
                    }
                } else {
                    return;
                }
            }
            if ((view = this.listView.getChildAt(position - firstVisPosition)) != null) {
                AdapterBaseView tag = (AdapterBaseView)view.getTag();
                tag.bindDataSource(position, this.getDataSource(position));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void scrollTo(int position) {
        if (this.listView != null && position == this.listView.getLastVisiblePosition()) {
            this.listView.setSelection(position);
        }
    }

    @Override
    public void sendReadReceipt(final TalkMessageBean talkMessageBean) {
        this.proxyRepository.changeMessageState(talkMessageBean, 4, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.d("ERROR: Change message state error." + e.getMessage());
            }

            public void onNext(Integer integer) {
                if (integer != 0) {
                    LogUtil.e("Change message state failed.");
                    return;
                }
                LogUtil.d("Change message state success.");
                int length = ChatListAdapter.this.mDataSource.size();
                for (int i = length - 1; i >= 0; --i) {
                    if (((TalkMessageBean)ChatListAdapter.this.mDataSource.get(i)).getId() != talkMessageBean.getId()) continue;
                    talkMessageBean.setMessageState(4);
                    ChatListAdapter.this.mDataSource.set(i, talkMessageBean);
                    ChatListAdapter.this.updateItem(i, talkMessageBean);
                    break;
                }
            }
        });
    }

    @Override
    public void postDestroyAnimate(TalkMessageBean bean) {
        IMProxyMessageEvent.RefreshMessageEvent event = new IMProxyMessageEvent.RefreshMessageEvent();
        event.setMsgAccount(bean.getFrom());
        bean.setMessageState(5);
        event.setTalkMessageBean(bean);
        BusProvider.getInstance().post(event);
    }

    @Override
    public TalkMessageBean getTalkMessage(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return (TalkMessageBean)this.getItem(position);
    }

    @Override
    public void getTalkMessageEntity(long msgId, Subscriber<TalkMessageBean> subscriber) {
        this.proxyRepository.getTalkMessage(msgId, subscriber);
    }

    @Override
    public void getAccount(String account, int talkType, Subscriber<AccountBean> subscriber) {
        IMUiKitProxyImpl.getInstance().getAccount(account, talkType, subscriber);
    }

    @Override
    public void clickWebMessage(TalkMessageBean talkMessageBean) {
        if (talkMessageBean == null) {
            return;
        }
        WebPageInfo pInfo = talkMessageBean.getWebPageInfo();
        if (pInfo.getWebUri() != null) {
            Intent intent = new Intent();
            intent.setAction(this.getActivity().getPackageName() + "." + "android.intent.action.XDJA.VIEW");
            Uri uri = Uri.parse((String)pInfo.getWebUri());
            intent.setData(uri);
            this.getActivity().startActivity(intent);
        }
    }

    @Override
    public void downLoadFile(final TalkMessageBean talkMessageBean, final FileInfo fileInfo) {
        if (fileInfo == null) {
            LogUtil.e("start load file, but file info is null error.");
            return;
        }
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        fileInfos.add(fileInfo);
        this.proxyRepository.downloadFile(fileInfos, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.d("Download image error." + e.getMessage());
            }

            public void onNext(Integer integer) {
                LogUtil.d("Start to loadNormalFile file.");
                if (fileInfo.getFileType() == 1) {
                    boolean isCurrentPlaying = AudioPlayerManagerProxy.isPlayingWithMessage(fileInfo);
                    if (AudioPlayerManagerProxy.isPlaying()) {
                        AudioPlayerManagerProxy.stopPlay();
                    }
                    if (isCurrentPlaying) {
                        return;
                    }
                    AudioPlayerManagerProxy.startToPlay(fileInfo, talkMessageBean.getId(), false);
                }
            }
        });
    }

    @Override
    public void playVoice(TalkMessageBean bean) {
        LogUtil.d("start play voice file.");
        if (!TelphoneState.getPhotoStateIsIdle(this.getActivity().getApplicationContext())) {
            CommonTool.showToast(R.string.im_uikit_phone_is_inCall);
            return;
        }
        VoiceFileInfo fileInfo = (VoiceFileInfo)bean.getFileInfo();
        if (fileInfo == null || TextUtils.isEmpty((CharSequence)fileInfo.getFilePath())) {
            LogUtil.e("ERROR: start to play voice, but file is null  or file not exist.");
            return;
        }
        if (bean.isMine() || !bean.isMine() && fileInfo.getFileState() == 2) {
            if (!FileUtils.isFileExists(fileInfo.getFilePath())) {
                CommonTool.showToast(R.string.im_uikit_file_not_exist);
                return;
            }
        } else {
            this.downLoadFile(bean, fileInfo);
        }
        boolean isCurrentPlaying = AudioPlayerManagerProxy.isPlayingWithMessage(fileInfo);
        if (AudioPlayerManagerProxy.isPlaying()) {
            AudioPlayerManagerProxy.stopPlay();
        }
        if (isCurrentPlaying) {
            return;
        }
        AudioPlayerManagerProxy.startToPlay(fileInfo, bean.getId(), bean.getMessageState() < 4);
        if (!bean.isMine() && bean.getMessageState() < 4) {
            this.sendReadReceipt(bean);
        }
    }

    @Override
    public void previewVideo(TalkMessageBean dataSource) {
        LogUtil.d("start play video file.");
        VideoFileInfo fileInfo = (VideoFileInfo)dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: video file info is null error.");
            return;
        }
        if (!FileUtils.isFileExists(fileInfo.getFilePath())) {
            LogUtil.e("ERROR: file not exit.");
            return;
        }
        this.startPreviewActivity(fileInfo.getTalkMessageId());
        if (!dataSource.isMine() && dataSource.getMessageState() < 4) {
            this.sendReadReceipt(dataSource);
        }
    }

    @Override
    public void previewImage(TalkMessageBean dataSource) {
        LogUtil.d("Start preview image.");
        ImageFileInfo imageFile = (ImageFileInfo)dataSource.getFileInfo();
        if (imageFile == null) {
            LogUtil.e("ERROR: image file info is null error.");
            return;
        }
        if (!FileUtils.isFileExists(imageFile.getFilePath())) {
            LogUtil.e("ERROR: file not exit.");
            return;
        }
        this.startPreviewActivity(imageFile.getTalkMessageId());
    }

    @Override
    public void loadNormalFile(TalkMessageBean dataSource) {
        LogUtil.d("start open file.");
        if (dataSource == null) {
            LogUtil.e("ERROR: start open file, but data source is null.");
            return;
        }
        NormalFileInfo normalFileInfo = (NormalFileInfo)dataSource.getFileInfo();
        Intent intent = new Intent((Context)this.getActivity(), FileDownloadActivity.class);
        intent.putExtra("messageId", dataSource.getId());
        intent.putExtra("fileTranslateSize", normalFileInfo.getTranslateSize());
        this.mPresenter.startActivityForResult(intent, 9);
        if (!dataSource.isMine()) {
            this.sendReadReceipt(dataSource);
        }
    }

    @Override
    public void openNormalFile(TalkMessageBean dataSource) {
        NormalFileInfo fileInfo = (NormalFileInfo)dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: open file failed, file info is null.");
            return;
        }
        if (FileUtils.isFileExists(fileInfo.getFilePath())) {
            SystemHelper.openFile(this.getActivity(), fileInfo.getFilePath());
        } else {
            CommonTool.showToast(R.string.im_uikit_file_not_exist);
        }
    }

    @Override
    public void openSetting(String talkId, int talkType) {
        try {
            boolean result = IMUiKitProxyImpl.getInstance().openChatSettingCallback(talkId, talkType);
            if (!result) {
                IntentParam.startSettingActivity((Context)this.getActivity(), talkId, talkType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void openUserInfo(String account) {
        try {
            boolean bl = IMUiKitProxyImpl.getInstance().openChatUserInfoCallback(account);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onLongClickAtUser(final String groupId, final String account) {
        IMUiKitProxyImpl.getInstance().getAccount(account, 1, new Subscriber<AccountBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(AccountBean accountBean) {
                ChatListAdapter.this.mPresenter.onLongClickAtUser(groupId, account, accountBean.getDisplayName());
            }
        });
    }

    private void startPreviewActivity(long msgId) {
        Intent intent = new Intent();
        intent.setClass((Context)this.mPresenter.getActivity(), FilePreviewActivity.class);
        intent.putExtra("talkerId", this.mPresenter.getTalkFlag());
        intent.putExtra("messageId", msgId);
        this.mPresenter.startActivity(intent);
    }

    private int postDeleteMessageEvent(TalkMessageBean talkMessageBean) {
        try {
            IMProxyMessageEvent.DeleteMessageEvent messageEvent = new IMProxyMessageEvent.DeleteMessageEvent();
            messageEvent.setMsgAccount(talkMessageBean.getFrom());
            messageEvent.setTalkMessageBean(talkMessageBean);
            BusProvider.getInstance().post(messageEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public void startAnimation(String filePath, long messageId) {
        int position = this.getPositionWithId(messageId);
        if (position >= 0) {
            this.updateItem(position, this.getDataSource(position));
        }
    }

    public void stopAnimation(String filePath, long messageId) {
        int position = this.getPositionWithId(messageId);
        if (position >= 0) {
            this.updateItem(position, this.getDataSource(position));
        }
    }

    public void playNextAudio(String filePath, long messageId, boolean isNext) {
        LogUtil.d("start play next voice file.msgId:" + messageId);
        int position = this.getPositionWithId(messageId);
        if (position >= 0) {
            TalkMessageBean dataSource = this.getDataSource(position);
            this.updateItem(position, dataSource);
            if (dataSource.isMine() || !isNext) {
                return;
            }
            TalkMessageBean bean = this.findNextVoiceItem(position, messageId);
            if (bean != null && !bean.isMine()) {
                this.playVoice(bean);
            }
        }
    }

    private TalkMessageBean findNextVoiceItem(int curPosition, long messageId) {
        TalkMessageBean bean = new TalkMessageBean();
        bean.setId(messageId);
        int size = this.mDataSource.size();
        if (curPosition >= 0) {
            for (int i = curPosition + 1; i < size; ++i) {
                FileInfo fileInfo;
                TalkMessageBean talkMessageBean = this.mDataSource.get(i);
                if (talkMessageBean.isMine() || (fileInfo = talkMessageBean.getFileInfo()) == null || fileInfo.getFileType() != 1) continue;
                if (talkMessageBean.getMessageState() >= 4 || fileInfo.getFileState() != 2) break;
                return talkMessageBean;
            }
        }
        return null;
    }

    private int getPositionWithId(long messageId) {
        TalkMessageBean bean = new TalkMessageBean();
        bean.setId(messageId);
        return this.mDataSource.indexOf(bean);
    }

    @Override
    public boolean getVoiceMessageIsPlaying(FileInfo fileInfo) {
        return AudioPlayerManagerProxy.isPlayingWithMessage(fileInfo);
    }

    private void showDialog(int resoureId, final boolean isCanRecall, final TalkMessageBean messageBean) {
        new CustomDialog((Context)this.getActivity(), new CustomDialog.OnCloseListener(){

            @Override
            public void onClick(Dialog dialog, boolean confirm) {
                if (isCanRecall && messageBean != null && confirm) {
                    SpUtils.getInstance().saveBoolean("recall_msg", true);
                    ChatListAdapter.this.recallMsg(messageBean);
                }
            }
        }).setIfShowNegative(false).setDialogTitle(R.string.im_uikit_hint).setDialogContent(resoureId).setPositiveButton(R.string.im_uikit_ok_text).show();
    }
}

