/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.xdja.im.uikit.R;

public class CustomDialog
extends Dialog
implements View.OnClickListener {
    private Context mContext;
    private TextView mContentTv;
    private TextView mTitleTv;
    private TextView mSubmitTv;
    private TextView mCancelTv;
    private String mTitle;
    private String mContent;
    private String mPositiveName;
    private String mNegativeName;
    private boolean ifShowNegative = true;
    private int mTitleResId;
    private int mContentResId;
    private int mPositiveResId;
    private int mNagativeResId;
    private OnCloseListener mListener;

    public CustomDialog(Context context) {
        super(context);
        this.mContext = context;
    }

    public CustomDialog(Context context, String content) {
        super(context, R.style.dialog);
        this.mContext = context;
        this.mContent = content;
    }

    public CustomDialog(Context context, int themeResId, String content) {
        super(context, themeResId);
        this.mContext = context;
        this.mContent = content;
    }

    public CustomDialog(Context context, OnCloseListener listener) {
        super(context, R.style.dialog);
        this.mContext = context;
        this.mListener = listener;
    }

    public CustomDialog(Context context, int themeResId, OnCloseListener listener) {
        super(context, themeResId);
        this.mContext = context;
        this.mListener = listener;
    }

    public CustomDialog setDialogTitle(String mTitle) {
        this.mTitle = mTitle;
        return this;
    }

    public CustomDialog setDialogTitle(@StringRes int resId) {
        this.mTitleResId = resId;
        return this;
    }

    public CustomDialog setDialogContent(String content) {
        this.mContent = content;
        return this;
    }

    public CustomDialog setDialogContent(@StringRes int resId) {
        this.mContentResId = resId;
        return this;
    }

    public CustomDialog setPositiveButton(String name) {
        this.mPositiveName = name;
        return this;
    }

    public CustomDialog setPositiveButton(@StringRes int resId) {
        this.mPositiveResId = resId;
        return this;
    }

    public CustomDialog setNegativeButton(String name) {
        this.mNegativeName = name;
        return this;
    }

    public CustomDialog setNegativeButton(@StringRes int resId) {
        this.mNagativeResId = resId;
        return this;
    }

    public CustomDialog setIfShowNegative(boolean ifShowNegative) {
        this.ifShowNegative = ifShowNegative;
        return this;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.im_uikit_dialog_costom);
        this.setCanceledOnTouchOutside(false);
        this.initView();
    }

    private void initView() {
        this.mContentTv = (TextView)this.findViewById(R.id.tv_content);
        this.mTitleTv = (TextView)this.findViewById(R.id.tv_title);
        this.mSubmitTv = (TextView)this.findViewById(R.id.tv_submit);
        this.mCancelTv = (TextView)this.findViewById(R.id.tv_cancel);
        this.mSubmitTv.setOnClickListener((View.OnClickListener)this);
        this.mCancelTv.setOnClickListener((View.OnClickListener)this);
        if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
            this.mTitleTv.setText((CharSequence)this.mTitle);
        }
        if (this.mTitleResId > 0) {
            this.mTitleTv.setText(this.mTitleResId);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mContent)) {
            this.mContentTv.setText((CharSequence)this.mContent);
        }
        if (this.mContentResId > 0) {
            this.mContentTv.setText(this.mContentResId);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mPositiveName)) {
            this.mSubmitTv.setText((CharSequence)this.mPositiveName);
        }
        if (this.mPositiveResId > 0) {
            this.mSubmitTv.setText(this.mPositiveResId);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mNegativeName)) {
            this.mCancelTv.setText((CharSequence)this.mNegativeName);
        }
        if (!this.ifShowNegative) {
            this.mCancelTv.setVisibility(8);
        }
        if (this.mNagativeResId > 0) {
            this.mCancelTv.setText(this.mNagativeResId);
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.tv_cancel) {
            if (this.mListener != null) {
                this.mListener.onClick(this, false);
            }
            this.dismiss();
        } else if (i == R.id.tv_submit) {
            if (this.mListener != null) {
                this.mListener.onClick(this, true);
            }
            this.dismiss();
        }
    }

    public static interface OnCloseListener {
        public void onClick(Dialog var1, boolean var2);
    }
}

