/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.base.frame.view.AdapterSuperBaseView;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.utils.DataCache;
import com.xdja.im.core.utils.ToolUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.TimeUtil;
import com.xdja.im.uikit.view.CircleImageView;
import java.util.ArrayList;
import java.util.List;
import rx.Subscriber;

public class BaseChatItem
extends AdapterSuperBaseView<ChatListAdapterPresenter, TalkMessageBean>
implements AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean> {
    public static final long TIME_DIFFERENCE = 300000L;
    private CircleImageView mUserHeader;
    protected TextView mUserName;
    private TextView mTimeLineTv;
    protected BaseListDialog mPopDialog;
    protected List<ImOption> mImOptions = new ArrayList<ImOption>();

    @Override
    protected void injectView() {
        super.injectView();
        this.mUserHeader = (CircleImageView)this.findViewById(R.id.img_user_icon);
        this.mTimeLineTv = (TextView)this.findViewById(R.id.tv_timeLine);
        this.mPopDialog = new BaseListDialog(this.getContext()){

            @Override
            public List<ImOption> getOptions() {
                return BaseChatItem.this.buildImOptions();
            }
        };
        this.mUserHeader.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String account = ((TalkMessageBean)BaseChatItem.this.dataSource).getFrom();
                if (TextUtils.isEmpty((CharSequence)account)) {
                    LogUtil.e("ERROR: User account is null.");
                    return;
                }
                LogUtil.d("Start open user setting.(" + account + ")");
                ((ChatListAdapterPresenter)BaseChatItem.this.getPresenter()).openUserInfo(account);
            }
        });
        this.mUserHeader.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return false;
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        if (position == 0) {
            this.setTimeLineVisible(dataSource.getShowTime());
        } else {
            TalkMessageBean lastMessage = ((ChatListAdapterPresenter)this.getPresenter()).getTalkMessage(this.curPosition - 1);
            if (lastMessage != null && dataSource.getShowTime() - lastMessage.getShowTime() > 300000L) {
                this.mTimeLineTv.setVisibility(0);
                this.mTimeLineTv.setText((CharSequence)TimeUtil.convertChatTime(dataSource.getShowTime()));
            } else {
                this.mTimeLineTv.setVisibility(8);
            }
        }
        if (dataSource.getMessageType() == 101) {
            return;
        }
        try {
            this.loadUserData();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTimeLineVisible(long time) {
        this.mTimeLineTv.setVisibility(0);
        this.mTimeLineTv.setText((CharSequence)TimeUtil.convertChatTime(time));
    }

    protected int getNormalTextColor() {
        return -16777216;
    }

    protected int getLimitTextColor() {
        return -3355444;
    }

    private List<ImOption> buildImOptions() {
        this.mImOptions.add(new ImOption(1, this.getStringRes(R.string.im_uikit_chat_option_delete)));
        this.mImOptions.add(new ImOption(2, this.getStringRes(R.string.im_uikit_chat_option_copy)));
        this.mImOptions.add(new ImOption(3, this.getStringRes(R.string.im_uikit_chat_option_recall)));
        this.mImOptions.add(new ImOption(4, this.getStringRes(R.string.im_uikit_chat_option_resend)));
        this.mImOptions.add(new ImOption(5, this.getStringRes(R.string.im_uikit_chat_option_forward)));
        return this.mImOptions;
    }

    protected void loadUserData() {
        final String account = ((TalkMessageBean)this.dataSource).getFrom();
        if (TextUtils.isEmpty((CharSequence)account)) {
            return;
        }
        String sessionFlag = ToolUtils.getSessionTag(account, 1);
        AccountBean accountBean = (AccountBean)DataCache.getInstance().get(sessionFlag);
        if (accountBean != null) {
            this.mUserHeader.loadImage(accountBean.getAvatarUrl(), true, R.mipmap.im_uikit_user_header_40dp);
            if (this.mUserName != null && ((TalkMessageBean)this.dataSource).isGroupMsg() && !((TalkMessageBean)this.dataSource).isMine()) {
                this.mUserName.setText((CharSequence)accountBean.getDisplayName());
            }
            return;
        }
        ((ChatListAdapterPresenter)this.getPresenter()).getAccount(account, 1, new Subscriber<AccountBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.w("ERROR: get account failed." + account);
            }

            public void onNext(AccountBean accountBean) {
                if (accountBean == null) {
                    return;
                }
                BaseChatItem.this.mUserHeader.loadImage(accountBean.getAvatarUrl(), true, R.mipmap.im_uikit_user_header_40dp);
                if (BaseChatItem.this.mUserName != null && ((TalkMessageBean)BaseChatItem.this.dataSource).isGroupMsg() && !((TalkMessageBean)BaseChatItem.this.dataSource).isMine()) {
                    BaseChatItem.this.mUserName.setText((CharSequence)accountBean.getDisplayName());
                }
            }
        });
    }

    public abstract class MyLongClick
    implements LongClickCbk {
    }

    public static interface LongClickCbk {
        public void onLongClick();
    }
}

