/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.annotation.TargetApi;
import android.app.Activity;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.text.Html;
import android.text.TextPaint;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.xdja.google.gson.Gson;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.base.frame.view.AdapterSuperBaseView;
import com.xdja.im.common.imageloader.GlideCircleTransform;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.custom.CustomMsgInfo;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.SessionListAdapterPresenter;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.TimeUtil;

public class ViewSessionItem
extends AdapterSuperBaseView<SessionListAdapterPresenter, TalkSessionBean>
implements AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean> {
    private LinearLayout mLayout;
    private ImageView mUserHeader;
    private TextView mUnReadCountTv;
    private ImageView mNewMsgFlagImg;
    private TextView mUserNameTv;
    private TextView mContentTv;
    private ImageView mMessageStateImg;
    private TextView mDisplayTimeTv;
    private ImageView mDisturbFlag;

    @Override
    protected void injectView() {
        super.injectView();
        this.mLayout = (LinearLayout)this.findViewById(R.id.layout_session_item);
        this.mUserHeader = (ImageView)this.findViewById(R.id.img_user_header);
        this.mUnReadCountTv = (TextView)this.findViewById(R.id.tv_unread_message);
        this.mNewMsgFlagImg = (ImageView)this.findViewById(R.id.img_new_message_flag);
        this.mUserNameTv = (TextView)this.findViewById(R.id.tv_user_name);
        this.mContentTv = (TextView)this.findViewById(R.id.tv_content);
        this.mMessageStateImg = (ImageView)this.findViewById(R.id.img_message_state);
        this.mDisplayTimeTv = (TextView)this.findViewById(R.id.tv_display_time);
        this.mDisturbFlag = (ImageView)this.findViewById(R.id.img_disturb_flag);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);
        if (dataSource == null) {
            LogUtil.e("dataSource is null.");
            return;
        }
        this.updateSessionSenderInfo();
        this.updateSessionBaseInfo();
        this.updateUnreadCount();
        this.updateMessageState();
        this.updateSessionParam();
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
    }

    private void updateSessionSenderInfo() {
        if (null != ((TalkSessionBean)this.dataSource).getLastMsgAccount()) {
            this.updateSenderView(IMUiKitProxyImpl.getInstance().getAccount(((TalkSessionBean)this.dataSource).getLastMsgAccount(), 1));
        } else {
            this.updateSenderView();
        }
    }

    private void updateSessionBaseInfo() {
        int imgId = R.mipmap.im_uikit_user_header_40dp;
        if (((TalkSessionBean)this.dataSource).getTalkType() == 2) {
            imgId = R.mipmap.im_uikit_group_avatar_40;
        }
        this.updateSessionBaseView(IMUiKitProxyImpl.getInstance().getAccount(((TalkSessionBean)this.dataSource).getTalkerAccount(), ((TalkSessionBean)this.dataSource).getTalkType()));
    }

    private void updateSenderView() {
        this.mContentTv.setText(this.ellipsize(this.getContent("")));
        this.mDisplayTimeTv.setText((CharSequence)this.getDisplayTime());
    }

    private void updateSenderView(AccountBean accountBean) {
        if (null != accountBean) {
            this.mContentTv.setText(this.ellipsize(this.getContent(accountBean.getDisplayName())));
            this.mDisplayTimeTv.setText((CharSequence)this.getDisplayTime());
        }
    }

    private void updateSessionBaseView(AccountBean accountBean) {
        if (null == accountBean) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)accountBean.getDisplayName())) {
            this.mUserNameTv.setText((CharSequence)accountBean.getDisplayName());
        } else {
            this.mUserNameTv.setText((CharSequence)accountBean.getAccount());
        }
        Drawable avatarDrawable = accountBean.getAvatarDrawable();
        if (avatarDrawable != null) {
            this.mUserHeader.setImageDrawable(avatarDrawable);
            return;
        }
        int imgId = R.mipmap.im_uikit_user_header_40dp;
        if (((TalkSessionBean)this.dataSource).getTalkType() == 2) {
            imgId = R.mipmap.im_uikit_group_avatar_40;
        }
        String avatarUrl = accountBean.getAvatarUrl();
        Glide.with((Activity)this.getActivity()).load(avatarUrl).placeholder(imgId).error(imgId).bitmapTransform(new Transformation[]{new GlideCircleTransform(this.getContext())}).into(this.mUserHeader);
    }

    private void updateSessionParam() {
        if (((TalkSessionBean)this.dataSource).getParam() != null) {
            if (((TalkSessionBean)this.dataSource).getParam().isTop()) {
                this.mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_top);
            } else {
                this.mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_normal);
            }
            if (((TalkSessionBean)this.dataSource).getParam().isDisturb()) {
                if (this.mDisturbFlag != null) {
                    this.mDisturbFlag.setVisibility(0);
                }
            } else if (this.mDisturbFlag != null) {
                this.mDisturbFlag.setVisibility(8);
            }
        } else {
            if (this.mDisturbFlag != null) {
                this.mDisturbFlag.setVisibility(8);
            }
            this.mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_normal);
        }
    }

    private void updateMessageState() {
        this.mMessageStateImg.setVisibility(8);
        TalkMessageBean talkMessageBean = ((TalkSessionBean)this.dataSource).getLastMsg();
        if (talkMessageBean == null) {
            LogUtil.w("session last message is null.");
            return;
        }
        if (talkMessageBean.getMessageType() == 102 || talkMessageBean.getMessageType() == 101) {
            return;
        }
        if (talkMessageBean.getFrom() == null || talkMessageBean.getTo() == null) {
            return;
        }
        SessionParam param = ((TalkSessionBean)this.dataSource).getParam();
        if (param != null && !TextUtils.isEmpty((CharSequence)param.getDraftContent()) && param.getDraftTime() > 0L) {
            return;
        }
        if (talkMessageBean.getMessageState() == 1) {
            this.mMessageStateImg.setVisibility(0);
            this.mMessageStateImg.setImageResource(R.mipmap.im_uikit_ic_message_state_sending);
        } else if (talkMessageBean.getMessageState() == 0) {
            this.mMessageStateImg.setVisibility(0);
            this.mMessageStateImg.setImageResource(R.mipmap.im_uikit_ic_message_state_fail);
        }
    }

    private void updateUnreadCount() {
        int notReadCount = ((TalkSessionBean)this.dataSource).getNotReadCount();
        if (notReadCount > 0) {
            this.setNotReadShow(true);
            SessionParam param = ((TalkSessionBean)this.dataSource).getParam();
            if (param != null && param.isDisturb()) {
                this.mUnReadCountTv.setVisibility(8);
                this.mNewMsgFlagImg.setVisibility(0);
                return;
            }
            if (notReadCount > 99) {
                this.setNotReadCount((CharSequence)Html.fromHtml((String)"<b>...</b>"));
            } else {
                this.setNotReadCount(notReadCount + "");
            }
        } else {
            this.setNotReadShow(false);
        }
    }

    private void setNotReadShow(boolean isShow) {
        if (isShow) {
            this.mUnReadCountTv.setVisibility(0);
        } else {
            this.mUnReadCountTv.setVisibility(8);
        }
        this.mNewMsgFlagImg.setVisibility(8);
    }

    private void setNotReadCount(CharSequence countText) {
        this.mUnReadCountTv.setText(countText);
    }

    private void setTextColor(@ColorRes int idRes) {
        this.mContentTv.setTextColor(this.getColorRes(idRes));
    }

    protected String getUserName() {
        return ((TalkSessionBean)this.dataSource).getLastMsgAccount();
    }

    protected CharSequence getContent(String displayName) {
        return "";
    }

    protected String getDisplayTime() {
        if (((TalkSessionBean)this.dataSource).getLastTime() > 0L) {
            return TimeUtil.convertSessionTime(((TalkSessionBean)this.dataSource).getLastTime());
        }
        return "";
    }

    public void setTimeVisibility(int visibility) {
        this.mDisplayTimeTv.setVisibility(visibility);
    }

    public CharSequence getCustomStr(TalkMessageBean talkMessageBean) {
        CustomMsgInfo customMsgInfo = (CustomMsgInfo)new Gson().fromJson(talkMessageBean.getContent(), CustomMsgInfo.class);
        int type = customMsgInfo.getType();
        int state = customMsgInfo.getState();
        boolean isVideoCallback = type == 3 || type == 4 || type == 5;
        long amountOfTime = customMsgInfo.getAmountOfTime();
        String content = "";
        boolean isMine = talkMessageBean.isMine();
        if (state == 4) {
            content = isMine ? "\u5df2\u53d6\u6d88" : (isVideoCallback ? (type == 5 ? "\u672a\u63a5\u89c6\u9891\u901a\u8bdd" : "\u672a\u63a5\u89c6\u9891\u56de\u4f20") : (type == 1 ? "\u672a\u63a5\u8bed\u97f3\u901a\u8bdd" : "\u672a\u63a5\u8bed\u97f3\u4f1a\u8bae"));
        } else if (state == 6) {
            content = isMine ? "\u5bf9\u65b9\u65e0\u5e94\u7b54" : (isVideoCallback ? (type == 5 ? "\u672a\u63a5\u89c6\u9891\u901a\u8bdd" : "\u672a\u63a5\u89c6\u9891\u56de\u4f20") : (type == 1 ? "\u672a\u63a5\u8bed\u97f3\u901a\u8bdd" : "\u672a\u63a5\u8bed\u97f3\u4f1a\u8bae"));
        } else if (state == 5) {
            content = isMine ? "\u5bf9\u65b9\u5df2\u62d2\u7edd" : "\u5df2\u62d2\u7edd";
        } else if (state == 2) {
            content = this.buildMsgContent(type, amountOfTime);
        } else if (state == 8) {
            content = "\u5df2\u5728\u5176\u5b83\u8bbe\u5907\u5904\u7406";
        } else if (state == 9) {
            content = "\u8fde\u63a5\u5931\u8d25";
        }
        return content;
    }

    private String buildMsgContent(int type, long amountOfTime) {
        StringBuilder builder = new StringBuilder();
        switch (type) {
            case 3: 
            case 4: {
                builder.append("\u89c6\u9891\u56de\u4f20");
                builder.append(" " + this.getFormatTime(amountOfTime));
                break;
            }
            case 1: {
                builder.append("\u8bed\u97f3\u901a\u8bdd");
                builder.append(" " + this.getFormatTime(amountOfTime));
                break;
            }
            case 2: {
                builder.append("\u8bed\u97f3\u4f1a\u8bae");
                break;
            }
            case 5: {
                builder.append("\u89c6\u9891\u901a\u8bdd");
                builder.append(" " + this.getFormatTime(amountOfTime));
            }
        }
        return builder.toString();
    }

    protected CharSequence formatDraft(String content) {
        String draftPreStr = "<font color=\"#941100\">" + this.getStringRes(R.string.im_uikit_draft) + "</font>";
        return Html.fromHtml((String)(draftPreStr + content));
    }

    @TargetApi(value=16)
    protected CharSequence ellipsize(CharSequence content) {
        return TextUtils.ellipsize((CharSequence)content, (TextPaint)this.mContentTv.getPaint(), (float)(this.mContentTv.getMaxWidth() - 8), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
    }

    private String getFormatTime(long amountOfTime) {
        String secondStr;
        long hour = amountOfTime / 3600L;
        long min = amountOfTime / 60L % 60L;
        long second = amountOfTime % 60L;
        String hourStr = "";
        String minStr = min < 10L ? "0" + min : "" + min;
        String string2 = secondStr = second < 10L ? "0" + second : "" + second;
        if (hour == 0L) {
            hourStr = "";
            return minStr + ":" + secondStr;
        }
        hourStr = hour < 10L ? "0" + hour : "" + hour;
        return hourStr + ":" + minStr + ":" + secondStr;
    }
}

