/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.PowerManager;
import android.text.Html;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.xdja.im.uikit.utils.ScreenInfoUtils;
import java.util.List;

public class FunctionUtils {
    public static ScreenInfoUtils getScreenInfo(Activity activity) {
        WindowManager wm = activity.getWindowManager();
        DisplayMetrics metric = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metric);
        ScreenInfoUtils screenInfo = new ScreenInfoUtils();
        screenInfo.setDensity(metric.density);
        screenInfo.setDensityDpi(metric.densityDpi);
        screenInfo.setHeight(metric.heightPixels);
        screenInfo.setWidth(metric.widthPixels);
        return screenInfo;
    }

    @SuppressLint(value={"BooleanMethodIsAlwaysInverted"})
    public static boolean isAnyNetworkConnected(Context context) {
        ConnectivityManager mgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo[] info = mgr.getAllNetworkInfo();
        if (info != null) {
            for (NetworkInfo anInfo : info) {
                if (anInfo.getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        return false;
    }

    public static CharSequence formatDraft(String draft) {
        String draftPreStr = "<font color=\"#941100\">[Draft]</font>";
        return Html.fromHtml((String)(draftPreStr + draft));
    }

    public static CharSequence formatAtRemind(String string2) {
        String atPreStr = "<font color=\"#941100\">[You were mentioned]</font>";
        return Html.fromHtml((String)(atPreStr + string2));
    }

    public static CharSequence formatAtRemind() {
        String atPreStr = "<font color=\"#941100\">[You were mentioned]</font>";
        return Html.fromHtml((String)atPreStr);
    }

    public static boolean isScreenOffOrLock(Context context) {
        KeyguardManager mKeyguardManager;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        boolean isOn = false;
        boolean isLock = true;
        if (pm != null) {
            isOn = pm.isScreenOn();
        }
        if ((mKeyguardManager = (KeyguardManager)context.getSystemService("keyguard")) != null) {
            try {
                isLock = mKeyguardManager.inKeyguardRestrictedInputMode();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return !isOn || isLock;
    }

    public static boolean isAppOnForeground(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List appInfos = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo info : appInfos) {
            if (!info.processName.equals(context.getPackageName()) || info.importance != 100) continue;
            return true;
        }
        return false;
    }

    public static String getCurrentActivityName(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ActivityManager.RunningTaskInfo info = (ActivityManager.RunningTaskInfo)am.getRunningTasks(1).get(0);
        return info.topActivity.getClassName();
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        if (drawable2 == null) {
            return null;
        }
        int w = drawable2.getIntrinsicWidth();
        int h = drawable2.getIntrinsicHeight();
        Bitmap.Config config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, w, h);
        drawable2.draw(canvas);
        return bitmap;
    }
}

