/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.content.ContextCompat;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.method.MovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.util.Pair;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.share.model.HyperLinkBean;
import com.xdja.im.uikit.HyperlinkMovementMethod;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.view.BaseChatItem;
import com.xdja.im.uikit.utils.HyperLinkUtil;
import com.xdja.im.uikit.utils.image.BitmapUtils;
import java.util.List;
import java.util.regex.Pattern;

public class RecognizeHyperlink {
    private static RecognizeHyperlink mInstance = new RecognizeHyperlink();
    String at = "@";
    private final int LINK_WEB = 1;
    private final int LINK_EMAIL = 2;
    private final int LINK_PHONE = 4;
    public final int ALL = 7;
    private final String[] webPrefix = new String[]{"http://", "https://", "rtsp://"};
    private final String[] emailPrefix = new String[]{"mailto:"};
    private Activity activity;
    private static final String GOOD_IRI_CHAR = "a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef";
    private static final Pattern IP_ADDRESS = Pattern.compile("((25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[0-9]))");
    private static final String GOOD_GTLD_CHAR = "a-zA-Z\uf900-\ufdcf\ufdf0-\uffef";
    private static final String GTLD = "[a-zA-Z\uf900-\ufdcf\ufdf0-\uffef]{2,63}";
    private static final String IRI = "[a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef]){0,1}";
    private static final String HOST_NAME = "([a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef]){0,1}\\.)+[a-zA-Z\uf900-\ufdcf\ufdf0-\uffef]{2,63}";
    private static final Pattern DOMAIN_NAME = Pattern.compile("(([a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef]){0,1}\\.)+[a-zA-Z\uf900-\ufdcf\ufdf0-\uffef]{2,63}|" + IP_ADDRESS + ")");
    private static final Pattern WEB_URL = Pattern.compile("((?:(http|https|Http|Https|rtsp|Rtsp):\\/\\/(?:(?:[a-zA-Z0-9\\$\\-\\_\\.\\+\\!\\*\\'\\(\\)\\,\\;\\?\\&\\=]|(?:\\%[a-fA-F0-9]{2})){1,64}(?:\\:(?:[a-zA-Z0-9\\$\\-\\_\\.\\+\\!\\*\\'\\(\\)\\,\\;\\?\\&\\=]|(?:\\%[a-fA-F0-9]{2})){1,25})?\\@)?)?(?:" + DOMAIN_NAME + ")(?:\\:\\d{1,5})?)(\\/(?:(?:[" + "a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef" + "\\;\\/\\?\\:\\@\\&\\=\\#\\~\\-\\.\\+\\!\\*\\'\\(\\)\\,\\_])|(?:\\%[a-fA-F0-9]{2}))*)?(?:\\b|$)");

    private RecognizeHyperlink() {
    }

    public static RecognizeHyperlink getInstance() {
        return mInstance;
    }

    public void recognizeHyperlinks(BaseChatItem.LongClickCbk cbk, TextView contentView, Activity activity, int type) {
        this.activity = activity;
        if (type == 0) {
            return;
        }
        String content = contentView.getText().toString();
        if (HyperLinkUtil.isALabelLink(content)) {
            Pair<String, List<HyperLinkBean>> aLink = HyperLinkUtil.parseALabelLink(content);
            if (aLink != null && aLink.first != null && ((String)aLink.first).length() > 0 && aLink.second != null && ((List)aLink.second).size() > 0) {
                this.setLinkSpan((List)aLink.second, (String)aLink.first, contentView, cbk);
            }
        } else {
            List<HyperLinkBean> links = HyperLinkUtil.parseContent(content, type);
            int size = links.size();
            if (size > 0) {
                this.setLinkSpan(links, content, contentView, cbk);
            }
        }
    }

    private void setLinkSpan(List<HyperLinkBean> links, String content, TextView contentView, final BaseChatItem.LongClickCbk cbk) {
        SpannableString spannableString = BitmapUtils.formatSpanContent(content, (Context)this.activity, 1.1f);
        for (final HyperLinkBean link : links) {
            ForegroundColorSpan linkColor = new ForegroundColorSpan(ContextCompat.getColor((Context)this.activity, (int)R.color.base_black_37));
            spannableString.setSpan((Object)linkColor, link.getStartPosition(), link.getEndPosition(), 33);
            spannableString.setSpan((Object)new SpanClickListenser(){

                @Override
                public void onClick(View widget) {
                    try {
                        if (link.getLinkType() == 1) {
                            Intent intent = new Intent();
                            intent.setAction(RecognizeHyperlink.this.activity.getPackageName() + "." + "android.intent.action.XDJA.VIEW");
                            Uri uri = Uri.parse((String)link.getHyperlink());
                            intent.setData(uri);
                            RecognizeHyperlink.this.activity.startActivity(intent);
                        } else if (link.getLinkType() == 2) {
                            Intent intent = new Intent();
                            intent.setAction("android.intent.action.SENDTO");
                            Uri uri = Uri.parse((String)link.getHyperlink());
                            intent.setData(uri);
                            RecognizeHyperlink.this.activity.startActivity(intent);
                        } else if (link.getLinkType() == 4) {
                            RecognizeHyperlink.this.clickPhoneLink(link.getHyperlink(), widget);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        new XToast(ActomaController.getAppConfigContext()).display("\u65e0\u53ef\u7528\u5e94\u7528");
                    }
                }

                public void updateDrawState(TextPaint ds) {
                    ds.setUnderlineText(false);
                }
            }, link.getStartPosition(), link.getEndPosition(), 33);
        }
        HyperlinkMovementMethod method = new HyperlinkMovementMethod();
        contentView.setText((CharSequence)spannableString);
        contentView.setMovementMethod((MovementMethod)method);
        contentView.setClickable(false);
        contentView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                cbk.onLongClick();
                return false;
            }
        });
    }

    private void clickPhoneLink(String group, View view) {
        InputMethodManager imm = (InputMethodManager)this.activity.getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.activity.getWindow().getDecorView().getWindowToken(), 0);
    }

    class SpanClickListenser
    extends ClickableSpan
    implements View.OnLongClickListener {
        SpanClickListenser() {
        }

        public void onClick(View v) {
        }

        public boolean onLongClick(View v) {
            return false;
        }
    }
}

