/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils.image;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import com.xdja.im.uikit.utils.ImageCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BitmapUtils {
    private static final int itemh = 360;
    private static final int itemw = 360;

    public static Bitmap getBitmapWithName(String fileName, Resources resource) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        InputStream inputStream = null;
        try {
            inputStream = resource.getAssets().open(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return BitmapFactory.decodeStream((InputStream)inputStream);
    }

    public static Bitmap small(Bitmap bitmap, float scale) {
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap resizeBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        if (resizeBmp != bitmap) {
            BitmapUtils.recycleBmp(bitmap);
        }
        return resizeBmp;
    }

    public static Bitmap getZoomedDrawable(String filePath, int zoom) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int mWidth = options.outWidth;
        int mHeight = options.outHeight;
        int s = 1;
        while (mWidth / s > 720 * zoom || mHeight / s > 720 * zoom) {
            s *= 2;
        }
        options = new BitmapFactory.Options();
        options.inSampleSize = s;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        options.inJustDecodeBounds = false;
        Bitmap bm = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        if (bm != null) {
            float fs;
            int h = bm.getHeight();
            int w = bm.getWidth();
            float ft = (float)w / (float)h;
            int neww = ft >= (fs = 1.0f) ? 360 * zoom : (int)((float)(360 * zoom) * ft);
            int newh = ft >= fs ? (int)((float)(360 * zoom) / ft) : 360 * zoom;
            float scaleWidth = (float)neww / (float)w;
            float scaleHeight = (float)newh / (float)h;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            bm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
            return bm;
        }
        return null;
    }

    public static Bitmap getZoomedBitMap(Bitmap bitmap, int zoom) {
        if (bitmap != null) {
            float fs;
            int h = bitmap.getHeight();
            int w = bitmap.getWidth();
            float ft = (float)w / (float)h;
            int neww = ft >= (fs = 1.0f) ? 360 * zoom : (int)((float)(360 * zoom) * ft);
            int newh = ft >= fs ? (int)((float)(360 * zoom) / ft) : 360 * zoom;
            float scaleWidth = (float)neww / (float)w;
            float scaleHeight = (float)newh / (float)h;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
            return bitmap;
        }
        return null;
    }

    public static void recycleBmp(Bitmap bitmap) {
        if (null != bitmap && !bitmap.isRecycled()) {
            bitmap = null;
        }
    }

    public static SpannableString formatSpanContent(CharSequence sourceContent, Context context, float smallScall) {
        if (sourceContent == null) {
            return null;
        }
        SpannableString spannableString = null;
        try {
            spannableString = new SpannableString(sourceContent);
            Pattern pattern = Pattern.compile("(\\[emoji_[0-9]{3}\\])");
            Matcher matcher = pattern.matcher(sourceContent);
            while (matcher.find()) {
                String emoStr = matcher.group(1);
                emoStr = emoStr.substring(1, emoStr.length() - 1);
                ImageCache imageCache = ImageCache.getInstance();
                Bitmap bitmap = null;
                if (smallScall == 0.7f) {
                    if (imageCache.smallCashGet(emoStr + "small") != null) {
                        bitmap = imageCache.smallCashGet(emoStr + "small");
                    } else {
                        bitmap = BitmapUtils.getBitmapWithName(emoStr, context.getResources());
                        bitmap = BitmapUtils.small(bitmap, smallScall);
                        imageCache.smallCashPut(emoStr + "small", bitmap);
                    }
                } else if (smallScall == 1.1f) {
                    if (imageCache.smallCashGet(emoStr + "large") != null) {
                        bitmap = imageCache.smallCashGet(emoStr + "large");
                    } else {
                        bitmap = BitmapUtils.getBitmapWithName(emoStr, context.getResources());
                        bitmap = BitmapUtils.small(bitmap, smallScall);
                        imageCache.smallCashPut(emoStr + "large", bitmap);
                    }
                }
                ImageSpan span = new ImageSpan(context, bitmap);
                spannableString.setSpan((Object)span, matcher.start(), matcher.end(), 33);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return spannableString;
    }
}

