/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.xdja.im.uikit.R;

public class CircleProgressBar
extends View {
    public static final int DEFAULT_COLOR = 0x73FFFFFF;
    private int mColor;
    private int mRadius = -1;
    private int mMax = 100;
    private int mProgress = -1;
    private final Paint paint = new Paint();

    public CircleProgressBar(Context context) {
        this(context, null);
    }

    public CircleProgressBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleProgressBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array2 = context.obtainStyledAttributes(attrs, R.styleable.CircleProgressBarStyle);
        int count = array2.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr2 = array2.getIndex(i);
            if (attr2 == R.styleable.CircleProgressBarStyle_color) {
                this.mColor = array2.getColor(attr2, 0x73FFFFFF);
                continue;
            }
            if (attr2 == R.styleable.CircleProgressBarStyle_radius) {
                this.mRadius = array2.getDimensionPixelSize(attr2, -1);
                continue;
            }
            if (attr2 != R.styleable.CircleProgressBarStyle_max) continue;
            this.mMax = array2.getInteger(attr2, 100);
        }
        array2.recycle();
    }

    protected void onDraw(Canvas canvas) {
        if (this.mRadius != -1 && this.getVisibility() == 0) {
            this.paint.setAntiAlias(true);
            float angle = 0.0f;
            if (this.mMax > 0 && this.mProgress >= 0) {
                angle = (float)this.mProgress / (float)this.mMax * 360.0f;
            }
            this.paint.setColor(this.mColor);
            RectF oval2 = new RectF(((float)this.getWidth() - (float)this.mRadius * 2.0f) / 2.0f, ((float)this.getHeight() - (float)this.mRadius * 2.0f) / 2.0f, (float)this.getWidth() - ((float)this.getWidth() - (float)this.mRadius * 2.0f) / 2.0f, (float)this.getHeight() - ((float)this.getHeight() - (float)this.mRadius * 2.0f) / 2.0f);
            canvas.drawArc(oval2, 270.0f, angle, true, this.paint);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.invalidate();
        }
    }

    public void setMax(int mMax) {
        this.mMax = mMax;
    }

    public void setProgress(int mProgress) {
        this.mProgress = mProgress;
        this.invalidate();
    }
}

