package com.xdja.im.base.di.component;

import com.xdja.im.base.di.module.DataStoreModule;
import com.xdja.im.base.di.module.RepositoryModule;
import com.xdja.im.base.di.scope.UserScope;
import com.xdja.im.core.repository.interf.ChatListCallBack;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.core.repository.interf.SecurityRepository;
import com.xdja.im.core.repository.interf.UserOperateRepository;
import com.xdja.im.core.repository.interf.datasource.CloudDataStore;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;
import com.xdja.im.core.repository.interf.datasource.MemoryDataStore;
import com.xdja.im.core.repository.interf.im.IMProxyCallBack;
import com.xdja.im.uikit.assistant.callback.MessageAssistantCallBack;
import com.xdja.im.uikit.newui.callback.ChatDetailCallBack;
import com.xdja.imsdk.ImClient;
import com.xdja.imsdk.callback.CallbackFunction;
import com.xdja.imsdk.callback.IMFileInfoCallback;
import com.xdja.imsdk.callback.IMMessageCallback;
import com.xdja.imsdk.callback.IMSecurityCallback;
import com.xdja.imsdk.callback.IMSessionCallback;

import dagger.Component;

/**
 * @Package: com.xdja.im.base.di.component
 * @Author: xdjaxa
 * @Creation: 2017-05-04 16:28
 * @Version V1.0
 * @Description:
 */
@UserScope
@Component(dependencies = ApplicationComponent.class,
        modules = {
                DataStoreModule.class,
                RepositoryModule.class
        })
public interface RepositoryComponent extends ApplicationComponent{

    ImClient imClient();

    CloudDataStore cloudDataStore();

    DiskDataStore diskDataStore();

    MemoryDataStore memoryDataStore();

    ProxyRepository proxyRepository();

    ChatListCallBack chatListCallBack();

    SecurityRepository securityRepository();

    UserOperateRepository userOperateRepository();

    IMProxyCallBack proxyCallBack();

    CallbackFunction callbackFunction();

    IMFileInfoCallback iMFileInfoCallback();

    IMSessionCallback iMSessionCallback();

    IMMessageCallback iMMessageCallback();

    IMSecurityCallback iMSecurityCallback();

    ChatDetailCallBack chatDetailCallBack();

    MessageAssistantCallBack messageAssistantCallBack();
}
