package com.xdja.im.base.di.component;

import com.xdja.im.base.di.module.ActivityModule;
import com.xdja.im.base.di.module.FragmentModule;
import com.xdja.im.base.di.scope.ActivityScope;
import com.xdja.im.core.service.KitService;
import com.xdja.im.lib.file.ui.activity.FileExplorerActivity;
import com.xdja.im.lib.file.ui.fragment.FileListFragment;
import com.xdja.im.lib.filemanage.adapter.LastFileListAdapterPresenter;
import com.xdja.im.lib.filemanage.fragment.FileListPresenter;
import com.xdja.im.lib.filemanage.fragment.LastFileListFragment;
import com.xdja.im.lib.filemanage.fragment.LastFilePagePresenter;
import com.xdja.im.lib.filemanage.fragment.LastPhotoAndVideoFragment;
import com.xdja.im.lib.filemanage.ui.FileExplorerPresenter;
import com.xdja.im.lib.historyfile.adapter.HistoryFileAdapterPresenter;
import com.xdja.im.lib.historyfile.adapter.HistoryPhotoAndVideoAdapter;
import com.xdja.im.lib.historyfile.fragment.HistoryFileListFragment;
import com.xdja.im.lib.historyfile.fragment.HistoryPhotoAndVideoFragment;
import com.xdja.im.lib.historyfile.ui.HistoryFileActivityPresenter;
import com.xdja.im.lib.share.ShareSessionListActivity;
import com.xdja.im.uikit.assistant.MessageAssistantActivity;
import com.xdja.im.uikit.ui.activity.ChatListActivity;
import com.xdja.im.uikit.ui.activity.FileDownloadActivity;
import com.xdja.im.uikit.ui.activity.FilePreviewActivity;
import com.xdja.im.uikit.ui.activity.HistoryFilePreviewActivity;
import com.xdja.im.uikit.ui.activity.SessionListActivity;
import com.xdja.im.uikit.ui.fragment.AssistantListFragment;
import com.xdja.im.uikit.ui.fragment.ChatListFragment;
import com.xdja.im.uikit.ui.fragment.SessionListFragment;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;

import dagger.Component;

/**
 * @Package: com.xdja.im.base.di.component
 * @Author: xdjaxa
 * @Creation: 2017-05-04 19:20
 * @Version V1.0
 * @Description:
 */
@ActivityScope
@Component(modules = {ActivityModule.class, FragmentModule.class},
        dependencies = RepositoryComponent.class)
public interface UserComponent {

    void inject(SessionListFragment fragment);

    void inject(ChatListFragment fragment);

    void inject(ChatListActivity activity);

    void inject(FileListFragment fileListFragment);

    void inject(FileExplorerActivity activity);

    void inject(FileDownloadActivity activity);

    void inject(FilePreviewActivity activity);

    void inject(HistoryFilePreviewActivity activity);

    void inject(KitService service);

    void inject(SessionListActivity sessionListActivity);

    //新增

    void inject(ChatListAdapterPresenter presenter);

//    void inject(NotificationUtil notificationUtil);
    void inject(FileExplorerPresenter fileExplorerPresenter);

    void inject(LastFilePagePresenter lastFilePagePresenter);

    void inject(FileListPresenter fileListPresenter);

    void inject(LastPhotoAndVideoFragment lastPhotoAndVideoFragment);

    void inject(LastFileListAdapterPresenter lastFileListAdapterPresenter);

    void inject(LastFileListFragment lastFileListFragment);

    void inject(HistoryFileActivityPresenter historyFileActivityPresenter);

    void inject(HistoryFileListFragment historyFileListFragment);

    void inject(HistoryFileAdapterPresenter historyFileAdapterPresenter);

    void inject(HistoryPhotoAndVideoFragment historyPhotoAndVideoFragment);

    void inject(HistoryPhotoAndVideoAdapter historyPhotoAndVideoAdapter);

    //share
    void inject(ShareSessionListActivity shareSessionListActivity);
    void inject(MessageAssistantActivity messageAssistantActivity);
    void inject(AssistantListFragment assistantListFragment);
}
