package com.xdja.im.common.database.helper;

import com.xdja.im.common.database.bean.SettingDb;
import com.xdja.im.common.database.dao.SettingEntityDao;
import com.xdja.im.core.model.param.DisturbParam;
import com.xdja.im.core.model.param.RemindParam;
import com.xdja.im.core.model.param.SettingParam;
import com.xdja.im.uikit.ImUiKit;

/**
 * @Package: com.xdja.im.common.database.helper
 * @Author: xdjaxa
 * @Creation: 2017-05-31 9:05
 * @Version V1.0
 * @Description:IM设置帮助类
 */
public class IMSettingHelper {

    /**
     * 获取所有配置信息
     *
     * @return
     */
    public static SettingParam getSettingParam() {
        SettingParam param = new SettingParam();
        SettingDb settingDb = SettingEntityDao.getInstance().get();
        if (settingDb == null) {
            settingDb = new SettingDb();
            settingDb.setAccount(ImUiKit.getInstance().getCurAccount());
            settingDb.setRemindType(1);
            settingDb.setRemindVoice(1);
            settingDb.setRemindVibrate(1);
            SettingEntityDao.getInstance().insert(settingDb);
        }
        param.setAccount(settingDb.getAccount());
        param.setRemind(getRemindParam(settingDb));
        param.setReceiveMode(settingDb.getReceiverMode() == 1);
        param.setDisturb(getDisturbParam(settingDb));
        return param;
    }

    /**
     * 获取消息提醒
     *
     * @param settingDb
     * @return
     */
    public static RemindParam getRemindParam(SettingDb settingDb) {
        RemindParam remind = new RemindParam();
        if (settingDb.getRemindType() == 1) {
            remind.setOpen(true);
            remind.setVoice(settingDb.getRemindVoice() == 1);
            remind.setVibrate(settingDb.getRemindVibrate() == 1);
        } else {
            remind.setOpen(false);
            remind.setVoice(false);
            remind.setVibrate(false);
        }
        return remind;
    }

    /**
     * 获取勿扰配置
     *
     * @param settingDb
     * @return
     */
    public static DisturbParam getDisturbParam(SettingDb settingDb) {
        DisturbParam disturb = new DisturbParam();
        if (settingDb.getDisturbMode() == 1) {
            disturb.setOpen(true);
            disturb.setStartTime(settingDb.getDisturbStart());
            disturb.setEndTime(settingDb.getDisturbEnd());
        } else {
            disturb.setOpen(false);
            disturb.setStartTime(0);
            disturb.setEndTime(0);
        }
        return disturb;
    }

    /**
     * 新消息提醒方式
     *
     * @param type
     */
    public static void setRemindType(int type) {
        SettingDb settingDb = SettingEntityDao.getInstance().get();
        if (settingDb == null) {
            settingDb = new SettingDb();
            settingDb.setAccount(ImUiKit.getInstance().getCurAccount());
            settingDb.setRemindType(type);
            SettingEntityDao.getInstance().insert(settingDb);
        } else {
            settingDb.setRemindType(type);
            SettingEntityDao.getInstance().update(settingDb);
        }
    }

    /**
     * 是否响铃
     *
     * @param type
     */
    public static void setRemindVoiceType(int type) {
        SettingDb settingDb = SettingEntityDao.getInstance().get();
        if (settingDb == null) {
            settingDb = new SettingDb();
            settingDb.setAccount(ImUiKit.getInstance().getCurAccount());
            settingDb.setRemindVoice(type);
            SettingEntityDao.getInstance().insert(settingDb);
        } else {
            settingDb.setRemindVoice(type);
            SettingEntityDao.getInstance().update(settingDb);
        }
    }

    /**
     * 是否震动
     *
     * @param type
     */
    public static void setRemindVibrateType(int type) {
        SettingDb settingDb = SettingEntityDao.getInstance().get();
        if (settingDb == null) {
            settingDb = new SettingDb();
            settingDb.setAccount(ImUiKit.getInstance().getCurAccount());
            settingDb.setRemindVibrate(type);
            SettingEntityDao.getInstance().insert(settingDb);
        } else {
            settingDb.setRemindVibrate(type);
            SettingEntityDao.getInstance().update(settingDb);
        }
    }

    /**
     * 听筒模式
     *
     * @param mode
     */
    public static void setReceiverMode(int mode) {
        SettingDb settingDb = SettingEntityDao.getInstance().get();
        if (settingDb == null) {
            settingDb = new SettingDb();
            settingDb.setAccount(ImUiKit.getInstance().getCurAccount());
            settingDb.setReceiverMode(mode);
            SettingEntityDao.getInstance().insert(settingDb);
        } else {
            settingDb.setReceiverMode(mode);
            SettingEntityDao.getInstance().update(settingDb);
        }
    }

    /**
     * 勿扰模式
     *
     * @param mode
     */
    public static void setDisturbMode(int mode) {
        SettingDb settingDb = SettingEntityDao.getInstance().get();
        if (settingDb == null) {
            settingDb = new SettingDb();
            settingDb.setAccount(ImUiKit.getInstance().getCurAccount());
            settingDb.setDisturbMode(mode);
            SettingEntityDao.getInstance().insert(settingDb);
        } else {
            settingDb.setDisturbMode(mode);
            SettingEntityDao.getInstance().update(settingDb);
        }
    }

    /**
     * 勿扰开始时间
     *
     * @param startTime
     */
    public static void setDisturbStart(long startTime) {
        SettingDb settingDb = SettingEntityDao.getInstance().get();
        if (settingDb == null) {
            settingDb = new SettingDb();
            settingDb.setAccount(ImUiKit.getInstance().getCurAccount());
            settingDb.setDisturbStart(startTime);
            SettingEntityDao.getInstance().insert(settingDb);
        } else {
            settingDb.setDisturbStart(startTime);
            SettingEntityDao.getInstance().update(settingDb);
        }
    }

    /**
     * 勿扰结束时间
     *
     * @param endTime
     */
    public static void setDisturbEnd(long endTime) {
        SettingDb settingDb = SettingEntityDao.getInstance().get();
        if (settingDb == null) {
            settingDb = new SettingDb();
            settingDb.setAccount(ImUiKit.getInstance().getCurAccount());
            settingDb.setDisturbEnd(endTime);
            SettingEntityDao.getInstance().insert(settingDb);
        } else {
            settingDb.setDisturbEnd(endTime);
            SettingEntityDao.getInstance().update(settingDb);
        }
    }
}
