package com.xdja.im.core.proxy;

import android.app.Activity;
import android.content.Context;
import android.view.View;

import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.core.callback.AccountCallback;
import com.xdja.im.core.callback.CommonCallback;
import com.xdja.im.core.callback.NotificationCallback;
import com.xdja.im.core.callback.OnChatAt2GroupCallBack;
import com.xdja.im.core.callback.OnChatMeetCallBack;
import com.xdja.im.core.callback.OnChatSettingCallback;
import com.xdja.im.core.callback.OnChatUserInfoCallback;
import com.xdja.im.core.callback.OnCustomItemViewCallback;
import com.xdja.im.core.callback.OnShareOverCallback;
import com.xdja.im.core.callback.ShareSelectCallback;
import com.xdja.im.core.callback.UnReadMessageCallback;
import com.xdja.im.core.model.account.AccountAction;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.uikit.newui.base.RecyclerViewHolder;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;

import rx.Subscriber;

/**
 * @Package: com.xdja.im.core.proxy
 * @Author: xdjaxa
 * @Creation: 2017-06-26 8:48
 * @Version V1.0
 * @Description:Ui Kit对外提供的接口
 */
public interface IMUiKitProxy {

    /**
     * 获取联系人账号接口
     *
     * @param callback
     */
    void setAccountCallback(AccountCallback callback);

    /**
     * 通知栏消息回调
     *
     * @param callback
     */
    void setNotificationCallback(NotificationCallback callback);

    /**
     * 未读消息数回调
     *
     * @param callback
     */
    void setUnReadMessageCallback(UnReadMessageCallback callback);
    /**
     * 通用回调接口
     *
     * @param callback
     */
    void setCommonCallback(CommonCallback callback);


    /**
     * 启动聊天设置界面回调
     *
     * @param callback
     */
    void setOpenChatSettingCallback(OnChatSettingCallback callback);
    /**
     * 打开用户信息界面
     *
     * @param callback
     */
    void setOpenChatUserInfoCallback(OnChatUserInfoCallback callback);

    /**
     * 用户加入会议回掉
     *
     * @param callback
     */
    void setOnChatMeetCallBack(OnChatMeetCallBack callback);

    /**
     * 分享操作回掉
     *
     * @param callback
     */
    void setShareSelectCallback(ShareSelectCallback callback);


    /**
     * 分享完成操作回掉
     */
    void registerOnShareOverCallback(OnShareOverCallback callback);
    /**
     * 自定义聊天界面itemView回调
     */
    void registerOnCustomItemViewCallback(OnCustomItemViewCallback callback);
    /**
     * 根据联系人账号，获取联系信息
     *
     * @param account 联系人账号
     * @param type    联系人类型
     * @return 联系人信息
     */
    void getAccount(String account, int type, Subscriber<AccountBean> subscriber);

    /**
     * 获取账号信息
     * @param account
     * @param type
     * @return
     */
    AccountBean getAccount(String account, int type);
    /**
     * 联系人状态变化通知事件
     *
     * @param account 联系人账号
     * @param action  {@link AccountAction}
     */
    void notifyAccountChanged(String account, AccountAction action);

    /**
     * 通知信息
     *
     * @param sessionBean
     * @param newMsgCnt
     * @param isDisturb
     * @return
     */
    boolean notify(TalkSessionBean sessionBean, int newMsgCnt, boolean isDisturb);

    /**
     * 更新未读消息数
     *
     * @param count 未读消息数
     */
    void updateUnReadMessageCount(int count);

    /**
     * 打开会话设置界面
     *
     * @param sessionId
     * @param sessionType
     */
    boolean openChatSettingCallback(String sessionId, int sessionType);
    /**
     * 打开用户信息界面
     *
     * @param account
     */
    boolean openChatUserInfoCallback(String account);
    /***
     *当前账号是否在群组中
     * */
    public boolean isShowGroupSetting(String groupId);

    /**
     * 启动位置界面
     * */
    void startLocation(String atNo);

    /**
     * 启动视频回传
     * */
    void startCallback(String atNo);

    /**
     * 启动语音
     * */
    void startVoice(String atNo , int type);

    void addMeetting(String account,String groupId);


    void callSessionContact(Context context,int type,String action);

    void callSessionSearch(Context context,String key,int type,String action);

    /**
     * 群成员设置回调
     */
    void setAt2GroupMembersCallback(OnChatAt2GroupCallBack callBack);

    void clearSessionCache();
    /**
     * 跳转群成员界面
     * @param groupId
     */
    void go2AtGroupMembersList(String groupId,String account);

    void shareOverCallback(Context context);

    void notifyGroupMembsItemClick(String mGroupId, String account, String nickName);
    View getThirdTypeItem(Activity activity, TalkMessageBean talkMessageBean);

    RecyclerViewHolder getThirdViewHolderItem(Activity activity, TalkMessageBean talkMessageBean);
}
