package com.xdja.im.core.push;

import android.content.Context;
import android.text.TextUtils;

import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.pushsdk.PushClient;

import java.util.ArrayList;

/**
 * @Package: com.xdja.im.core.push
 * @Author: xdjaxa
 * @Creation: 2017-05-08 9:58
 * @Version V1.0
 * @Description:
 */
public class PushControllerImp implements PushController {

    public static final String TOPIC_IM = "/im";

    public static String clientId;

    public static String subTopic;

    /**
     * 框架订阅的主题
     */
    private ArrayList<String> mTopics;

    private PushControllerImp() {
    }

    private static class SingletonInstance {
        private static final PushControllerImp mInstance = new PushControllerImp();
    }

    public static PushControllerImp getInstance() {
        return SingletonInstance.mInstance;
    }

//    @Override
//    public boolean startPush(String clientId) {
//
//        LogUtil.d("start push...");
//
//        Context context = ImUiKit.getInstance().getContext();
//        if (context == null || TextUtils.isEmpty(clientId)) {
//            LogUtil.e("ERROR: client id is null." + clientId);
//            return false;
//        }
//        this.clientId = clientId;
//        this.subTopic = clientId + TOPIC_IM;
//
//        LogUtil.d("start init push " + clientId + ",subTopic:" + subTopic);
//        int result = PushClient.init(context, clientId);
//        subTopics(context);
//        LogUtil.d("start push result " + result);
//        return result == 0;
//    }

    @Override
    public boolean startPush(String appId, String userId, String key) {
        Context context = ImUiKit.getInstance().getContext();
        if (context == null) {
            LogUtil.e("ERROR: client id is null." + clientId);
            return false;
        }
        this.subTopic = appId + "/" + userId + TOPIC_IM;

        LogUtil.d("subTopic:" + subTopic);
        int result = PushClient.init(context, appId,userId,key);
        subTopics(context);
        return result == 0;
    }

    @Override
    public boolean releasePush() {
        LogUtil.d("releaseProxy push...");

        Context context = ImUiKit.getInstance().getContext();
        if (context == null) {
            LogUtil.e("Release push failed. context is null.");
            return false;
        }
        PushClient.unsubscribe(context, mTopics);
        int release = PushClient.release(context);
        return release == 0;
    }

    private void subTopics(Context context) {
        mTopics = new ArrayList<>();
        mTopics.add(subTopic);
        PushClient.subTopic(context, mTopics);
    }
}
