package com.xdja.im.lib.album.ui.viewholder;

import android.app.Activity;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;

import com.xdja.im.common.imageloader.CustomImageLoader;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.lib.album.ImageDataSource;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.album.bean.ImageItem;
import com.xdja.im.uikit.R;

/**
 * @Package: com.xdja.im.lib.album.ui.viewholder
 * @Author: xdjaxa
 * @Creation: 2017-04-24 16:03
 * @Version V1.0
 * @Description:
 */
public class ImageViewHolder extends BaseViewHolder {

    private ImageView mTargetImg;

    public CheckBox mSelectChx;

    private View mMaskView;

    public ImageViewHolder(final Activity activity, View itemView) {
        super(activity, itemView);
        mTargetImg = (ImageView) findViewById(R.id.img_local_image);
        mSelectChx = (CheckBox) findViewById(R.id.chx_item_select);
        mMaskView = findViewById(R.id.mask);

        //图片选择按钮监听器
        mSelectChx.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

            }
        });
        mSelectChx.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int selectLimit = ImagePickerManager.getInstance().getConfig().getMaxSelectNum();
                if (mSelectChx.isChecked() &&
                        ImageDataSource.getInstance().getSelects().size() >= selectLimit) {
                    mSelectChx.setChecked(false);
                    mMaskView.setVisibility(View.GONE);
                    CommonTool.showToast(String.format(activity.getString(R.string.im_uikit_img_select_limit), selectLimit));
                    return;
                }
                if (mSelectChx.isChecked()) {
                    mMaskView.setVisibility(View.VISIBLE);
                } else {
                    mMaskView.setVisibility(View.GONE);
                }
                if (mItemDataChangedListener != null) {
                    mItemDataChangedListener.onDataChanged(getLayoutPosition(), mSelectChx.isChecked());
                }
            }
        });

    }

    @Override
    public void bindData(final ImageItem data) {
        if (data == null) {
            mTargetImg.setImageResource(R.mipmap.im_uikit_pic_default);
            return;
        }
        boolean isSelected = ImageDataSource.getInstance().getSelects().contains(data);
        mSelectChx.setChecked(isSelected);
        if (isSelected) {
            mMaskView.setVisibility(View.VISIBLE);
        } else {
            mMaskView.setVisibility(View.GONE);
        }

        mTargetImg.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mItemClickListener != null) {
                    mItemClickListener.onItemClick(getLayoutPosition(), data);
                }
            }
        });

        try {
            CustomImageLoader.getInstance().crateBuilder()
                    .load(data.getPath())
                    .preLoad(mImageSize, mImageSize)
                    .placeholder(R.mipmap.im_uikit_pic_default)
                    .error(R.mipmap.im_uikit_pic_default)
                    .centerCrop()
                    .into(mTargetImg)
                    .build();

            /*ImagePickerManager.getInstance().getImageLoader().loadImage(
                    mActivity,
                    mTargetImg,
                    data.getPath(),
                    ImageView.ScaleType.CENTER_CROP,
                    mImageSize,
                    mImageSize);*/
        } catch (Exception e) {
            mTargetImg.setImageResource(R.mipmap.im_uikit_pic_default);
        } catch (OutOfMemoryError e) {
            mTargetImg.setImageResource(R.mipmap.im_uikit_pic_default);
        }
    }
}
