package com.xdja.im.lib.file.ui.view;

import com.xdja.im.core.utils.IMFileTools;
import com.xdja.im.lib.file.bean.FileItemNode;
import com.xdja.im.lib.file.bean.FileListType;
import com.xdja.im.lib.file.widget.recyclerview.ItemViewDelegate;
import com.xdja.im.lib.file.widget.recyclerview.ViewHolder;
import com.xdja.im.uikit.R;

public class ViewDirTitleDelegate implements ItemViewDelegate<FileItemNode> {

    private int mType;

    public ViewDirTitleDelegate(int type) {
        this.mType = type;
    }

    @Override
    public int getItemViewLayoutId() {
        return R.layout.im_uikit_fragment_file_dir;
    }

    @Override
    public boolean isForViewType(FileItemNode item, int position) {
        return !item.isLeaf();
    }

    @Override
    public void covert(ViewHolder viewHolder, FileItemNode fileItemNode, int position) {
        String title = (String) fileItemNode.getValue();
        if (mType == FileListType.RECENT.getType()) {
            try {
                viewHolder.setText(R.id.tv_file_title, fileLineTimeConvert(title));
            } catch (Exception e) {
                viewHolder.setText(R.id.tv_file_title, title);
            }
        } else {
            viewHolder.setText(R.id.tv_file_title, title);
        }

        /*try {
            viewHolder.setText(R.id.tv_file_title, fileLineTimeConvert(title));
        } catch (Exception e) {
            viewHolder.setText(R.id.tv_file_title, title);
        }*/

        int resourceId = !fileItemNode.isExpand() ?
                R.drawable.im_uikit_indicator_unexpanded :
                R.drawable.im_uikit_indicator_expanded;
        viewHolder.setImageWithResource(R.id.iv_file_expand, resourceId);
    }

    private int fileLineTimeConvert(String timeLine) {
        int timeLineTitle = 0;
        int timeLineType = Integer.valueOf(timeLine);
        switch (timeLineType) {
            case IMFileTools.TIME_WITHIN_TODAY:
                timeLineTitle = R.string.im_uikit_last_file_today;
                break;
            case IMFileTools.TIME_YESTERDAY:
                timeLineTitle = R.string.im_uikit_last_file_yesterday;
                break;
            case IMFileTools.TIME_WITHIN_WEEK:
                timeLineTitle = R.string.im_uikit_last_within_week;
                break;
            case IMFileTools.TIME_WITHIN_MONTH:
                timeLineTitle = R.string.im_uikit_last_within_month;
                break;
            case IMFileTools.TIME_WITHIN_MONTH_AGO:
                timeLineTitle = R.string.im_uikit_last_month_ago;
                break;
        }
        return timeLineTitle;
    }
}
