package com.xdja.im.lib.filemanage.util;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.widget.Toast;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.MimeUtils;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.io.File;

/**
 * 项目名称：ActomaV2
 * 类描述：
 * 创建人：xdjaxa
 * 创建时间：2016/12/16 14:02
 * 修改人：xdjaxa
 * 修改时间：2016/12/16 14:02
 * 修改备注：
 */
public class HistoryFileUtils {

    /**
     * add by zya 20161228
     * 对应路径文件是否存在
     *
     * @param path 检测的文件路径
     * @return
     */
    public static boolean isFileExist(String path) {
        if (TextUtils.isEmpty(path)) {
            return false;
        }

        File file = new File(path);
        return file.exists();
    }

    public static boolean isFileExist(TalkMessageBean bean) {
        FileInfo fileInfo = bean.getFileInfo();
        FileInfo fileExtraInfo = null;
        if (fileInfo instanceof ImageFileInfo) {
            if(((ImageFileInfo) fileInfo).isOriginal()) {
                fileExtraInfo = ((ImageFileInfo) fileInfo).getRawFileInfo();
                return fileExtraInfo.getFileState() == ConstDef.DONE;
            } else {
                return ((ImageFileInfo) fileInfo).getHdFileInfo().getFileState() == ConstDef.DONE;
            }
        } else if (fileInfo instanceof VideoFileInfo) {
            fileExtraInfo = ((VideoFileInfo) fileInfo).getRawFileInfo();
            return  fileExtraInfo.getFileState() == ConstDef.DONE;
        } else if (fileInfo instanceof ImageFileInfo) {
            fileExtraInfo = ((ImageFileInfo) fileInfo).getRawFileInfo();
            return fileExtraInfo.getFileState() == ConstDef.DONE;
        } else if (fileInfo instanceof FileInfo) {
            return fileInfo.getFileState() == ConstDef.DONE;
        } else {
            return false;
        }
    }


    public static boolean isForwardFileExist(TalkMessageBean bean) {
        FileInfo fileInfo = bean.getFileInfo();
        FileInfo fileExtraInfo = null;
        if (fileInfo instanceof ImageFileInfo) {
            if(((ImageFileInfo) fileInfo).isOriginal()) {
                fileExtraInfo = ((ImageFileInfo) fileInfo).getRawFileInfo();
                return !TextUtils.isEmpty(fileExtraInfo.getFilePath()) && new File(fileExtraInfo.getFilePath()).exists();
            } else {
                return !TextUtils.isEmpty(((ImageFileInfo) fileInfo).getHdFileInfo().getFilePath()) && new File(((ImageFileInfo) fileInfo).getHdFileInfo().getFilePath()).exists();
            }
        } else if (fileInfo instanceof VideoFileInfo) {
            fileExtraInfo = ((VideoFileInfo) fileInfo).getRawFileInfo();
            return !TextUtils.isEmpty(fileExtraInfo.getFilePath()) && new File(fileExtraInfo.getFilePath()).exists();
        } else if (fileInfo instanceof FileInfo) {
            return !TextUtils.isEmpty(fileInfo.getFilePath()) && new File(fileInfo.getFilePath()).exists();
        } else {
            return false;
        }
    }

    public static boolean isSendReadReceipt(TalkMessageBean bean){
        boolean isSend = false;
        FileInfo fileInfo = bean.getFileInfo();
        if(bean.getMessageState() >= ConstDef.STATE_READED || bean.isMine() || bean.isBomb() ||
                fileInfo == null){
            return isSend;
        }
        if(fileInfo instanceof ImageFileInfo){
            isSend = true;
        } else if (fileInfo instanceof ImageFileInfo){
            isSend = true;
        } else if (fileInfo instanceof VideoFileInfo){
            isSend = ((VideoFileInfo) fileInfo).getRawFileInfo().getFileState() == ConstDef.DONE;
        } else if (fileInfo instanceof FileInfo){
            isSend = fileInfo.getFileState() == ConstDef.DONE;
        }
        return isSend;
    }

    /**
     * 判断是否为某种类型
     *
     * @param suffix 需要匹配的类型
     * @param args   类型集合
     * @return true
     */
    private static boolean isFileType(String suffix, String[] args) {
        for (String arg : args) {
            if (arg.equals("." + suffix)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPicture() {
        return false;
    }

    /**
     * 根据后缀获取默认图标
     *
     * @param talkMessageBean
     * @return
     */
    public static int getIconWithSuffix(TalkMessageBean talkMessageBean) {

        FileInfo fileInfo = talkMessageBean.getFileInfo();
        if (fileInfo == null) {
            return R.drawable.im_uikit_ic_others;
        }

        int resId;
        String suffix = fileInfo.getSuffix();
        //String path = fileInfo.getFilePath();
        if (TextUtils.isEmpty(suffix)) {
            //suffix = path.substring(path.lastIndexOf(".") + 1).toLowerCase();
            return R.drawable.im_uikit_ic_others;
        }
        suffix = suffix.toLowerCase();

        if (isFileType(suffix, new String[]{".pdf"})) {
            resId = R.drawable.im_uikit_ic_pdf;
        } else if (isFileType(suffix, new String[]{".doc", ".docx"})) {
            resId = R.drawable.im_uikit_ic_doc;
        } else if (isFileType(suffix, new String[]{".xls", ".xlsx"})) {
            resId = R.drawable.im_uikit_ic_excel;
        } else if (isFileType(suffix, new String[]{".ppt", ".pptx"})) {
            resId = R.drawable.im_uikit_ic_ppt;
        } else if (isFileType(suffix, new String[]{".txt"})) {
            resId = R.drawable.im_uikit_ic_text;
        } else if (isFileType(suffix, IMFileUtils.mVideoSuffix)) {
            resId = R.drawable.im_uikit_ic_video;
        } else if (isFileType(suffix, IMFileUtils.mVoiceSuffix)) {
            resId = R.drawable.im_uikit_ic_music;
        } else if (isFileType(suffix, IMFileUtils.mImageSuffix)) {
            resId = R.drawable.im_uikit_ic_jpg;
        } else if (isFileType(suffix, IMFileUtils.mDocSuffix)) {
            resId = R.drawable.im_uikit_ic_doc;
        } else if (isFileType(suffix, IMFileUtils.mApkSuffix)) {
            resId = R.drawable.im_uikit_ic_apk;
        } else {
            resId = R.drawable.im_uikit_ic_others;
        }
        return resId;
    }


    /**
     * 根据filePath或者suffix或者打开这种扩展名的文件的intent
     *
     * @param filePath
     * @param suffix
     * @return
     */
    public static void intentBuilder(Activity activity, String filePath, String suffix){
        if(TextUtils.isEmpty(filePath)){
            Toast.makeText(activity,activity.getString(R.string.im_uikit_history_send_file_not_exist), Toast.LENGTH_SHORT).show();
            return ;
        }

        //add by zya ,ciphert mode
        boolean isCiphert = UniversalUtil.isCiphert(activity);
        if(isCiphert){
            new XToast(activity).display(activity.getString(R.string.im_uikit_ciphert_mode));
            return ;
        }//end by zya

        //String extension = suffix;
        Intent intent = new Intent();
        intent.setAction(Intent.ACTION_VIEW);
        //获取对应的mimetype
        //添加转换为小写。
        String type;
        if (TextUtils.isEmpty(suffix)) {
            type = "*/*";
        } else {
            type = MimeUtils.getMimeTypeWithExtension(suffix.toLowerCase());
            if (TextUtils.isEmpty(type)) {
                type = "*/*";
            }
        }

        if (!TextUtils.isEmpty(type) && !"*/*".equals(type)) {
            try {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                    //fix bug 13353 by zya,20170605
                    intent.setFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION
                            | Intent.FLAG_GRANT_WRITE_URI_PERMISSION);
                    Uri uri = FileProvider.getUriForFile(activity,
                            activity.getApplicationContext().getPackageName() + ".fileprovider",
                            new File(filePath));
                    intent.setDataAndType(uri, type);
                    //end by zya
                } else {
                    intent.setDataAndType(Uri.fromFile(new File(filePath)), type);
                }

                activity.startActivity(intent);
            } catch (Exception e) {
                LogUtil.d("","Not found exception;");
                Toast.makeText(activity, activity.getString(R.string.im_uikit_history_file_none_tool),
                        Toast.LENGTH_SHORT).show();
            }//end by zya
        } else if ("*/*".equals(type)) {
            //add by zya 20170103
            Toast.makeText(activity, activity.getString(R.string.im_uikit_history_file_none_tool),
                    Toast.LENGTH_SHORT).show();
            //end by zya
        }
    }
}
