package com.xdja.im.lib.filemanage.util;

/**
 * 项目名称：ImpData                           <br>
 * 类描述  ：网络状态上报                       <br>
 * 创建时间：2017/7/4 11:56                  <br>
 * 修改记录：                                 <br>
 *
 * @author liming@xdja.com                  <br>
 * @version V1.1.7                          <br>
 */

public class NetworkHelper {
    //正常状态
    public static final int NET_OK = 0;

    //连接不到服务器
    public static final int NO_SERVER = 1;

    //网络不可用
    public static final int NET_DISABLED =2;

    //当前网络状态
    private static int netState = NET_OK;

    //是否是第一次提示网络状态不佳，第一次提示时不弹出Toast
    private static boolean isFirstNotice = true;

    private static boolean changed = false;

    private static class singletonInstance {
        private static NetworkHelper mInstance = new NetworkHelper();
    }

    public static NetworkHelper getHelper() {
        return singletonInstance.mInstance;
    }

    public void receiveNetState(int state) {
        int lastState = netState;
        netState = state;

        changed = lastState != netState;
        isFirstNotice = !(lastState != NET_OK && (netState == lastState));
    }

    public int getNetState() {
        return netState;
    }

    public boolean networkUseless() {
        return !(netState == NET_OK);
    }

    public boolean isFirstNotice() {
        return isFirstNotice;
    }

    public boolean networkChanged() {
        return changed;
    }
}
