package com.xdja.im.lib.share.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.xdja.im.base.frame.Presenter;

/**
 * Created by wenqi on 2018/3/1.
 *
 */

public abstract class BaseShareSessionAdapterPresenter<P extends Presenter, D> extends RecyclerView.Adapter<BaseShareViewHolder> {

    public abstract P getPresenter();

    public abstract D getItemData(int position);

    public abstract int getItemSize();

    @Override
    public BaseShareViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(getItemLayoutRes(viewType), parent, false);
        return getViewHolder(viewType, view);
    }

    protected abstract int getItemLayoutRes(int viewType);

    @Override
    public void onBindViewHolder(BaseShareViewHolder holder, int position) {
        holder.bind(position, getItemData(position));
    }

    @Override
    public int getItemCount() {
        return getItemSize();
    }

    abstract BaseShareViewHolder getViewHolder(int viewType, View view);

}
