package com.xdja.im.lib.share.view;


import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.bumptech.glide.Glide;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.share.model.IntentBean;
import com.xdja.im.lib.share.model.ShareBean;
import com.xdja.im.lib.share.model.WebPageInfo;
import com.xdja.im.lib.share.presenter.ShareSessionListPresenter;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.constans.Constant;
import com.xdja.im.uikit.utils.ObjectUtil;
import com.xdja.im.uikit.view.CircleImageView;
import com.xdja.im.uikit.view.PastEditText;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by wenqi on 2018/3/6.
 * 分享dialog
 */

public class ShareDialog {

    private Context context;

    private TextView sharedialogtv;
    private CircleImageView sharedialogusericon;
    private TextView sharedialogusername;
    private LinearLayout sharedialogsingleuserlayout;
    private LinearLayout sharedialogmoreuserlayout;
    private ImageView sharedialogimageContent;
    private TextView sharedialogtextContent;
    private LinearLayout sharedialogcontentLayout;
    private PastEditText sharedialogmessageContent;
    private LinearLayout sharedialogeditLayout;
    private TextView sharedialogcancelbtn;
    private TextView sharedialogsendbtn;
    private LinearLayout sharedialogbuttonLayout;


    private AlertDialog alertDialog;
    private ShareSessionListPresenter shareSessionListPresenter;
    private List<ShareBean> list = new ArrayList<>();
    private IntentBean intentBean;
    private int type = -1;
    private boolean isForward = false;
    private Intent intent;


    public ShareDialog(@NonNull Context context, int type, ShareSessionListPresenter shareSessionListPresenter) {
        this.type = type;
        this.shareSessionListPresenter = shareSessionListPresenter;
        init(context);
    }


    private void init(Context context) {
        this.context = context;
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        alertDialog = builder.create();
        View view = LayoutInflater.from(context).inflate(R.layout.im_uikit_share_dialog_layout, null);
        this.sharedialogbuttonLayout = (LinearLayout) view.findViewById(R.id.share_dialog_buttonLayout);
        this.sharedialogsendbtn = (TextView) view.findViewById(R.id.share_dialog_send_btn);
        this.sharedialogcancelbtn = (TextView) view.findViewById(R.id.share_dialog_cancel_btn);
        this.sharedialogeditLayout = (LinearLayout) view.findViewById(R.id.share_dialog_edit_Layout);
        this.sharedialogmessageContent = (PastEditText) view.findViewById(R.id.share_dialog_messageContent);
        this.sharedialogcontentLayout = (LinearLayout) view.findViewById(R.id.share_dialog_contentLayout);
        this.sharedialogtextContent = (TextView) view.findViewById(R.id.share_dialog_textContent);
        this.sharedialogimageContent = (ImageView) view.findViewById(R.id.share_dialog_imageContent);
        this.sharedialogmoreuserlayout = (LinearLayout) view.findViewById(R.id.share_dialog_more_user_layout);
        this.sharedialogsingleuserlayout = (LinearLayout) view.findViewById(R.id.share_dialog_single_user_layout);
        this.sharedialogusername = (TextView) view.findViewById(R.id.share_dialog_user_name);
        this.sharedialogusericon = (CircleImageView) view.findViewById(R.id.share_dialog_user_icon);
        this.sharedialogtv = (TextView) view.findViewById(R.id.share_dialog_tv);
        alertDialog.setView(view);
        sharedialogsendbtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (isForward){
                    shareSessionListPresenter.onDialogRequestForwardSend(list,intent, sharedialogmessageContent.getText().toString());
                } else
                shareSessionListPresenter.onDialogRequestSend(list, intentBean, sharedialogmessageContent.getText().toString());
                alertDialog.dismiss();
            }
        });
        sharedialogcancelbtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                shareSessionListPresenter.onDialogCancleSend();
                alertDialog.dismiss();
            }
        });
    }



    public void  showForwardDialog(ShareBean shareBean, Intent intent){
        this.intent = intent;
        list.clear();
        list.add(shareBean);
        isForward = true;
        if (shareBean != null) {
            Glide.with(context)
                    .load(shareBean.getAvatarUrl())
                    .error(getAvaterImage(shareBean))
                    .into(sharedialogusericon);
            sharedialogusername.setText(shareBean.getDisplayName());
        }
        if (intent != null){
            sharedialogcontentLayout.setVisibility(View.VISIBLE);
            ArrayList<FileInfo> fileList = (ArrayList<FileInfo>)intent.getSerializableExtra(ConstDef.TAG_SELECTFILE);
            if (ObjectUtil.collectionIsEmpty(fileList)) {
                int msgType = intent.getIntExtra(ConstDef.FORWARD_MSG_TYPE,0);
                switch (msgType){
                    case ConstDef.MSG_TYPE_TEXT:
                    case ConstDef.MSG_TYPE_AT_TEXT:
                        String content = intent.getExtras().getString(Intent.EXTRA_TEXT);
                        SpannableString ss = EmotionUtils.formatNormalSpanContent(content, context, content.length());
                        sharedialogtextContent.setText(ss);
                        sharedialogtextContent.setVisibility(View.VISIBLE);
                        break;
                    case ConstDef.MSG_TYPE_ASSISTANT:
                        String assistant_content = intent.getExtras().getString(Intent.EXTRA_TEXT);
                        sharedialogtextContent.setText(getSystemStr(assistant_content));
                        sharedialogtextContent.setVisibility(View.VISIBLE);
                        break;
                    case ConstDef.MSG_TYPE_PHOTO:
                        FileInfo imageFileInfo = (FileInfo) intent.getExtras().getSerializable(ConstDef.FORWARD_FILE);
                        Glide.with(context)
                                .load(imageFileInfo.getFilePath())
                                .into(sharedialogimageContent);
                        sharedialogimageContent.setVisibility(View.VISIBLE);
                        break;
                    case ConstDef.MSG_TYPE_VIDEO:
                        FileInfo videoFileInfo = (FileInfo) intent.getExtras().getSerializable(ConstDef.FORWARD_FILE);
                        Glide.with(context)
                                .load(videoFileInfo.getFilePath())
                                .into(sharedialogimageContent);
                        sharedialogimageContent.setVisibility(View.VISIBLE);
                        break;
                    case ConstDef.MSG_TYPE_FILE:
                        sharedialogimageContent.setImageResource(R.mipmap.im_uikit_ic_others);
                        sharedialogimageContent.setVisibility(View.VISIBLE);
                        break;
                    case ConstDef.MSG_TYPE_WEB:
                        WebPageInfo webPageInfo = (WebPageInfo) intent.getSerializableExtra(ConstDef.FORWARD_WEB);
                        sharedialogtextContent.setText(webPageInfo.getTitle());
                        sharedialogtextContent.setVisibility(View.VISIBLE);
                        sharedialogimageContent.setImageResource(R.mipmap.im_uikit_ic_others);
                        sharedialogimageContent.setVisibility(View.VISIBLE);
                        break;
                }
            }
        }
        if (!alertDialog.isShowing())
            alertDialog.show();

    }

    private String getSystemStr(CharSequence json) {
        String str = "";
        if (!TextUtils.isEmpty(json)) {
            try {
                JSONObject jsonObject = new JSONObject(json.toString());
                if (jsonObject.has("title_type")) {
                    str = "[" + jsonObject.getString("title_type") + "] ";
                }
                if (jsonObject.has("title")) {
                    str = str + jsonObject.getString("title");
                }
                return str;
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return str;
    }


    public void showSingleDialog(ShareBean shareBean, IntentBean intentBean) {
        isForward = false;
        list.clear();
        list.add(shareBean);
        this.intentBean = intentBean;
        if (shareBean != null) {
            Glide.with(context)
                    .load(shareBean.getAvatarUrl())
                    .error(getAvaterImage(shareBean))
                    .into(sharedialogusericon);
            sharedialogusername.setText(shareBean.getDisplayName());
        }
        if (intentBean != null) {
            if (!TextUtils.isEmpty(intentBean.getContent())) {
                SpannableString ss = EmotionUtils.formatNormalSpanContent(intentBean.getContent(), context, intentBean.getContent().length());
                sharedialogtextContent.setText(ss);
                sharedialogcontentLayout.setVisibility(View.VISIBLE);
                sharedialogtextContent.setVisibility(View.VISIBLE);
            }

            if (intentBean.getUriArrayList() != null && intentBean.getUriArrayList().size() == 1) {
                FileItem info = null;
                if (!TextUtils.isEmpty(intentBean.getType()) && intentBean.getType().startsWith(Constant.IMAGE_SHARE_TYPE)) {
                    String path = IMFileUtils.getImagePath(context,intentBean.getUriArrayList().get(0));
                    if (!TextUtils.isEmpty(path)) {
                        info = new FileItem();
                        info.setFileType(2);
                        info.setFilePath(path);
                    }
                } else {
                    info = IMFileUtils.queryLocalFiles(context, Uri.parse(Uri.decode(intentBean.getUriArrayList().get(0))));
                }
              if (info != null){
                sharedialogcontentLayout.setVisibility(View.VISIBLE);
                sharedialogimageContent.setVisibility(View.VISIBLE);
                if (info.getFileType() == 3 || info.getFileType() == 2){
                    Glide.with(context)
                            .load(info.getFilePath())
                            .diskCacheStrategy(DiskCacheStrategy.NONE)
                            .into(sharedialogimageContent);
                }

            } else {
                Toast.makeText(context,"抱歉，暂不支持的文件格式",Toast.LENGTH_SHORT).show();
                return;
            }
            }
        }
        if (!alertDialog.isShowing())
            alertDialog.show();
    }
 public void showMulitForwardDialog(List<ShareBean> list, Intent intent) {
        isForward = true;
        this.list.clear();
        this.list.addAll(list);
        this.intent = intent;
        sharedialogsingleuserlayout.removeAllViews();
        RecyclerView recyclerView = showMulitList(list);
        sharedialogsingleuserlayout.addView(recyclerView);

        if (intent != null){
            sharedialogcontentLayout.setVisibility(View.VISIBLE);
            int msgType = intent.getIntExtra(ConstDef.FORWARD_MSG_TYPE,0);
            switch (msgType){
                case ConstDef.MSG_TYPE_TEXT:
                case ConstDef.MSG_TYPE_AT_TEXT:
                    String content = intent.getExtras().getString(Intent.EXTRA_TEXT);
                    SpannableString ss = EmotionUtils.formatNormalSpanContent(content, context, content.length());
                    sharedialogtextContent.setText(ss);
                    sharedialogtextContent.setVisibility(View.VISIBLE);
                    break;
                case ConstDef.MSG_TYPE_ASSISTANT:
                    String assistant_content = intent.getExtras().getString(Intent.EXTRA_TEXT);
                    sharedialogtextContent.setText(getSystemStr(assistant_content));
                    sharedialogtextContent.setVisibility(View.VISIBLE);
                    break;
                case ConstDef.MSG_TYPE_PHOTO:
                    FileInfo imageFileInfo = (FileInfo) intent.getExtras().getSerializable(ConstDef.FORWARD_FILE);
                    Glide.with(context)
                            .load(imageFileInfo.getFilePath())
                            .into(sharedialogimageContent);
                    sharedialogimageContent.setVisibility(View.VISIBLE);
                    break;
                case ConstDef.MSG_TYPE_VIDEO:
                    FileInfo videoFileInfo = (FileInfo) intent.getExtras().getSerializable(ConstDef.FORWARD_FILE);
                    Glide.with(context)
                            .load(videoFileInfo.getFilePath())
                            .into(sharedialogimageContent);
                    sharedialogimageContent.setVisibility(View.VISIBLE);
                    break;
                case ConstDef.MSG_TYPE_FILE:
                    sharedialogimageContent.setImageResource(R.mipmap.im_uikit_ic_others);
                    sharedialogimageContent.setVisibility(View.VISIBLE);
                    break;
				case ConstDef.MSG_TYPE_WEB:
                    WebPageInfo webPageInfo = (WebPageInfo) intent.getSerializableExtra(ConstDef.FORWARD_WEB);
                    sharedialogtextContent.setText(webPageInfo.getWebUri());
                    sharedialogtextContent.setVisibility(View.VISIBLE);
                    sharedialogimageContent.setImageResource(R.mipmap.im_uikit_ic_others);
                    sharedialogimageContent.setVisibility(View.VISIBLE);
                    break;
            }
        }
        if (!alertDialog.isShowing())
            alertDialog.show();
    }

    public void showMulitDialog(List<ShareBean> list, IntentBean intentBean) {
        isForward = false;
        this.list.clear();
        this.list.addAll(list);
        this.intentBean = intentBean;
        sharedialogsingleuserlayout.removeAllViews();
        RecyclerView recyclerView = showMulitList(list);
        sharedialogsingleuserlayout.addView(recyclerView);

        if (intentBean != null) {
            if (!TextUtils.isEmpty(intentBean.getContent())) {
                SpannableString ss = EmotionUtils.formatNormalSpanContent(intentBean.getContent(), context, intentBean.getContent().length());
                sharedialogtextContent.setText(ss);
                sharedialogcontentLayout.setVisibility(View.VISIBLE);
                sharedialogtextContent.setVisibility(View.VISIBLE);
            }
            if (intentBean.getUriArrayList() != null && intentBean.getUriArrayList().size() == 1) {
                FileItem info = null;
                if (!TextUtils.isEmpty(intentBean.getType()) && intentBean.getType().startsWith(Constant.IMAGE_SHARE_TYPE)) {
                    String path = IMFileUtils.getImagePath(context,intentBean.getUriArrayList().get(0));
                    if (!TextUtils.isEmpty(path)) {
                        info = new FileItem();
                        info.setFileType(2);
                        info.setFilePath(path);
                    }
                } else {
                    info = IMFileUtils.queryLocalFiles(context, Uri.parse(Uri.decode(intentBean.getUriArrayList().get(0))));
                }
                sharedialogimageContent.setVisibility(View.VISIBLE);
                if (info != null){
                    if (info.getFileType() == 3 || info.getFileType() == 2){
                        Glide.with(context)
                                .load(info.getFilePath())
                                .diskCacheStrategy(DiskCacheStrategy.NONE)
                                .into(sharedialogimageContent);
                    }
                }else {
                    Toast.makeText(context,"抱歉，暂不支持的文件格式",Toast.LENGTH_SHORT).show();
                    return;
                }
            }
        }
        if (!alertDialog.isShowing())
            alertDialog.show();

    }


    private CircleImageView getCircleImageView() {
        return  new CircleImageView(context);
    }


    private RecyclerView showMulitList( List<ShareBean> list){
        RecyclerView recyclerView = new RecyclerView(context);
        LinearLayoutManager layoutManager = new LinearLayoutManager(context,LinearLayoutManager.HORIZONTAL,false);
        recyclerView.setLayoutManager(layoutManager);
        ListAdapter adapter = new ListAdapter(list);
        recyclerView.setAdapter(adapter);
        return recyclerView;
    }


    private class ListAdapter extends RecyclerView.Adapter<ListHolder>{

        private List<ShareBean> list;

        public ListAdapter(List<ShareBean> list){
            this.list = list;
        }

        @Override
        public ListHolder onCreateViewHolder(ViewGroup parent, int viewType) {

            View view = LayoutInflater.from(context).inflate(R.layout.im_uikit_share_item_user_icon_layout,parent,false);
            return new ListHolder(view);
        }

        @Override
        public void onBindViewHolder(ListHolder holder, int position) {
            Glide.with(context)
                    .load(list.get(position).getAvatarUrl())
                    .error(getAvaterImage(list.get(position)))
                    .into(holder.circleImageView);
        }

        @Override
        public int getItemCount() {
            return list.size();
        }
    }

    class ListHolder extends RecyclerView.ViewHolder{

        CircleImageView circleImageView;

        public ListHolder(View itemView) {
            super(itemView);
            this.circleImageView = (CircleImageView) itemView.findViewById(R.id.item_user_icon);
        }
    }

    private int getAvaterImage(ShareBean shareBean) {
        if (shareBean.getType() == ConstDef.CHAT_TYPE_P2P) {
            return R.mipmap.im_uikit_user_header_40dp;
        } else {
            return R.mipmap.im_uikit_group_avatar_40;
        }
    }

}
