package com.xdja.im.uikit.action.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.PowerManager;

import com.xdja.im.lib.audio.manager.TelphoneState;
import com.xdja.im.lib.audio.player.AudioPlayerManager;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.log.LogUtil;

import static android.media.AudioManager.FLAG_SHOW_UI;

/**
 * @Package: com.xdja.im.common.media
 * @Author: xdjaxa
 * @Creation: 2017-09-15 10:51
 * @Version V1.0
 * @Description:媒体播放器管理类
 */
public class MediaManger {

    private static String TAG = "MediaManger";

    private static final int VERSION = Build.VERSION.SDK_INT;

    private final AudioManager mAudioManager;

    private PowerManager.WakeLock mWakeLock;

    /**
     * 是否熄灭屏幕
     */
    private boolean isWakeAcquire = false;

    private boolean isReceiverMode = false;

    private boolean isHeadsetOn = false;

    public boolean isReceiverMode() {
        return isReceiverMode;
    }

    public void setReceiverMode(boolean receiverMode) {
        isReceiverMode = receiverMode;
    }

    private static class SingletonInstance {
        private static final MediaManger mInstance = new MediaManger();
    }

    @SuppressLint("InlinedApi")
    private MediaManger() {
        Context context = ActomaController.getApp();

        //音频管理模块
        mAudioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);

        if(VERSION >= Build.VERSION_CODES.LOLLIPOP) {
            //电源管理模块
            PowerManager pManager = (PowerManager) ActomaController.getApp()
                    .getSystemService(Context.POWER_SERVICE);
            mWakeLock = pManager.newWakeLock(PowerManager.PROXIMITY_SCREEN_OFF_WAKE_LOCK, TAG);
        }
    }

    public static MediaManger getInstance() {
        return SingletonInstance.mInstance;
    }


    /**
     * 听筒模式切换
     *
     * @param isReceiverMode 是否为听筒模式
     */
    public void onSensorChanged(boolean isReceiverMode) {

        if (!AudioPlayerManager.getInstance().isPlaying()) {
            if (isWakeAcquire) {
                wakeLockBrightRelease();
            }
            return;
        }

        if (isReceiverMode) {
            setReceiverModeOn();
        } else {
            setReceiverModeOff();
        }
    }

    /**
     * 设置耳机插入状态
     *
     * @param headsetOn true:插入耳机  false 未插入
     */
    public void setHeadsetOn(boolean headsetOn) {
        isHeadsetOn = headsetOn;
    }


    /**
     * 线控耳机是否插入
     *
     * @return
     */
    public boolean isHeadsetOn() {
        return isHeadsetOn ||
                mAudioManager.isWiredHeadsetOn();
    }

    /**
     * 还原音频mode，音频停止播放时调用
     */
    public void restoreAudioMode() {
        /** 20170217-mengbo-start: bug-7853 此处先简单处理，系统电话或voip响铃、通话中时，不设置音频模式，否则ace上表现，声音放大 review by liangliang **/
        if (!TelphoneState.getPhotoStateIsIdle(ActomaController.getApp())) {
            return;
        }
        /** 20170217-mengbo-end **/
        mAudioManager.setMode(AudioManager.MODE_NORMAL);
    }

    /**
     * 打开听筒模式
     */
    public void setReceiverModeOn() {
        //设置为通话模式
        mAudioManager.setMode(AudioManager.MODE_IN_COMMUNICATION);
        mAudioManager.setSpeakerphoneOn(false);
    }

    /**
     * 关闭听筒模式
     */
    public void setReceiverModeOff() {
        mAudioManager.setMode(AudioManager.MODE_NORMAL);
    }

    /**
     * 申请设备电源锁，灭屏
     */
    public void wakeLockBrightAcquire() {
        if (mWakeLock != null && !mWakeLock.isHeld()) {
            isWakeAcquire = true;
            mWakeLock.setReferenceCounted(false);
            mWakeLock.acquire(10*60*1000L /*10 minutes*/);
        }
    }

    /**
     * 释放电源设备锁，亮屏
     */
    public void wakeLockBrightRelease() {
        if (mWakeLock != null && mWakeLock.isHeld()) {
            isWakeAcquire = false;
            mWakeLock.release();
        }
    }

    public void releaseWakeLock() {
        if (mWakeLock != null && mWakeLock.isHeld()) {
            isWakeAcquire = false;
            mWakeLock.release(); // 释放设备电源锁
        }
    }

    /**
     * 是否熄灭屏幕
     *
     * @return
     */
    public boolean isWakeAcquire() {
        return isWakeAcquire;
    }
}
