package com.xdja.im.uikit.assistant;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.text.TextUtils;
import android.view.View;

import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.lib.audio.player.AudioListener;
import com.xdja.im.uikit.assistant.adapter.MessageAssistantAdapter;
import com.xdja.im.uikit.assistant.callback.MessageAssistantCallBack;
import com.xdja.im.uikit.assistant.presenter.MessageAssistantPresenter;
import com.xdja.im.uikit.assistant.view.MessageAssistantView;
import com.xdja.im.uikit.assistant.view.vu.MessageAssistantVu;
import com.xdja.im.uikit.base.ImBaseActivity;

import javax.inject.Inject;

import dagger.Lazy;

/**
 * Created by wenqi on 2018/5/8.
 *  消息助手
 */

public class MessageAssistantActivity extends ImBaseActivity<MessageAssistantPresenter,MessageAssistantVu> implements MessageAssistantPresenter{

    private LinearLayoutManager linearLayoutManager;
    private MessageAssistantAdapter adapter;
    @Inject
    Lazy<MessageAssistantCallBack> callBackLazy;

    @NonNull
    @Override
    protected Class<? extends MessageAssistantVu> getVuClass() {
        return MessageAssistantView.class;
    }

    @NonNull
    @Override
    protected MessageAssistantPresenter getPresenter() {
        return this;
    }

    @Override
    protected void onBindView(@Nullable Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (mComponent == null) {
            finish();
            return;
        }
        //注册回调
        mComponent.inject(this);

        try {
            Bundle arguments = getIntent().getExtras();
            callBackLazy.get().initChatPram(arguments, getVu(), this);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty(callBackLazy.get().getTalkId())) {
            finish();
            return;
        }
        BusProvider.getInstance().register(this);
        initViews();
    }

    private void initViews() {

        adapter = callBackLazy.get().buildAdapter();

        callBackLazy.get().loadMessages(0);
        getVu().setAdapter(adapter);
        getVu().setTitle("消息助手");
        getVu().setToolBarVisibility(View.VISIBLE);
        getVu().setToolBarAddVisibility(View.VISIBLE);
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    @Override
    public String getTalkFlag() {
        return callBackLazy.get().getTalkId() + "_" + callBackLazy.get().getTalkType();
    }

    @Override
    public LinearLayoutManager getLinearLayoutManager() {
        if (linearLayoutManager == null){
            linearLayoutManager = new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false);
        }
        return linearLayoutManager;
    }

    @Override
    public void downRefreshList() {
        callBackLazy.get().downRefreshList();
    }

}
