package com.xdja.im.uikit.assistant.callback.impl;

import android.os.Bundle;

import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;
import com.xdja.im.uikit.assistant.adapter.MessageAssistantAdapter;
import com.xdja.im.uikit.assistant.callback.MessageAssistantCallBack;
import com.xdja.im.uikit.assistant.presenter.MessageAssistantPresenter;
import com.xdja.im.uikit.assistant.view.vu.MessageAssistantVu;
import com.xdja.im.uikit.constans.Constant;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import rx.Subscriber;


/**
 * Created by wenqi on 2018/5/8.
 */

public class MessageAssistantCallBackImpl implements MessageAssistantCallBack {

    private String mTalkId;
    private int mTalkType;
    /**
     * 每页消息展示数量
     */
    private static final int PAGE_SIZE = 15;

    private List<TalkMessageBean> mMessageList = new ArrayList<>();

    private MessageAssistantAdapter mAdapter;

    private MessageAssistantVu vu;

    private MessageAssistantPresenter presenter;

    private ProxyRepository proxyRepository;

    private DiskDataStore diskDataStore;

    private UserCache userCache;


    @Inject
    public MessageAssistantCallBackImpl(ProxyRepository proxyRepository
            , DiskDataStore diskDataStore
            , UserCache userCache) {
        this.proxyRepository = proxyRepository;
        this.diskDataStore = diskDataStore;
        this.userCache = userCache;
    }

    @Override
    public void initChatPram(Bundle arguments, MessageAssistantVu vu, MessageAssistantPresenter presenter) {
        this.vu = vu;
        this.presenter = presenter;
        if (arguments != null) {
            try {
                //mCancelBottomPopMenuIdArray = arguments.getIntArray(EXTRA_KEY_CANCEL_BOTTOM_POP_MENU_ID_ARRAY);
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                mAdapter = null;
                mTalkId = arguments.getString(Constant.TAG_TALKERID);
                mTalkType = arguments.getInt(Constant.TAG_TALKTYPE, ConstDef.CHAT_TYPE_P2P);
            }
        }
    }

    @Override
    public String getTalkId() {
        return mTalkId;
    }

    @Override
    public int getTalkType() {
        return mTalkType;
    }

    @Override
    public void downRefreshList() {
        long msgId = 0;
        if (!mMessageList.isEmpty()) {
            msgId = mMessageList.get(0).getId();
        }
        LogUtil.d("do refresh, msgId :" + msgId);
        loadMessages(msgId);
    }

    @Override
    public MessageAssistantAdapter buildAdapter() {
        if (mAdapter == null)
            mAdapter = new MessageAssistantAdapter(presenter, vu, proxyRepository, mMessageList);
        return mAdapter;
    }

    @Override
    public void loadMessages(final long msgId) {
        LogUtil.d("Start load message msgId " + msgId);
        proxyRepository.getMessageList(mTalkId, mTalkType, msgId, PAGE_SIZE, new Subscriber<List<TalkMessageBean>>() {
            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                LogUtil.e("load message error:" + e.getMessage());
                mAdapter.notifyDataSetChanged();
            }

            @Override
            public void onNext(List<TalkMessageBean> talkMessageList) {
                if (talkMessageList == null /*|| talkMessageList.isEmpty()*/) {
                    return;
                }
                LogUtil.d(talkMessageList.toString());
                if (msgId == 0) {
                    //传入0，拉取最新消息
                    mMessageList.clear();
                }

                if (talkMessageList.size() > 0) {
                    mMessageList.addAll(0, talkMessageList);
                }
                buildAdapter().notifyDataSetChanged();
                if (vu.isRefreshing()) {
                    if (talkMessageList.size() > 0) {
                        vu.setListSelection(talkMessageList.size() - 1);
                    }
                } else {
                    if (mMessageList.size() > 0) {
                        vu.setListSelection(mMessageList.size() - 1);
                    }
                }
                if (mMessageList.size() > 0) {
                    vu.setListSelection(mMessageList.size() - 1);
                }
            }
        });
    }

}
