package com.xdja.im.uikit.assistant.holder;

import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.RecyclerViewHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.utils.sys.TimeUtil;

/**
 * Created by wenqi on 2018/5/8.
 * AssistantHolder
 */

public class AssistantHolder extends RecyclerViewHolder<TalkMessageBean, ChatDetailAdapterPresenter> {

    View itemView;
    LinearLayout linearLayout;
    private LinearLayout.LayoutParams layoutParams;
    /**
     * 时间差
     */
    public static final long TIME_DIFFERENCE = 5 * 60 * 1000;
    /**
     * 时间线
     */
    private TextView mTimeLineTv;

    public AssistantHolder(View itemView) {
        super(itemView);
        this.itemView = itemView;
        linearLayout = itemView.findViewById(R.id.view_custom_third_view_layout);
        mTimeLineTv = (TextView) findViewById(R.id.tv_timeLine);
        layoutParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }


    @Override
    public void bindData(int position, TalkMessageBean itemData) {
        super.bindData(position, itemData);
        if (itemData != null) {
//            try {
//                JSONObject jsonObject = new JSONObject(itemData.getContent());
//                if (jsonObject.has("type")) {
//                    int type = jsonObject.getInt("type");
//                    if (AssistantUtil.getInstance().ifHasAdded(type)) {
//                        linearLayout.removeAllViews();
//                        linearLayout.addView(AssistantUtil.getInstance().getTypeView(type), layoutParams);
//                    } else {
//                        View view = getPresenter().getThirdTypeViewItem(getPresenter().getActivity(), itemData.getContent());
//                        if (view != null){
//                            linearLayout.removeAllViews();
//                            linearLayout.addView(view, layoutParams);
//                        }
//                        AssistantUtil.getInstance().addView(type, view);
//                    }
//                }
//            } catch (JSONException e) {
//                e.printStackTrace();
//            }
            //时间线计算
            if (position == 0) {
                setTimeLineVisible(dataSource.getShowTime());
            } else {
                TalkMessageBean lastMessage = getPresenter().getTalkMessage(curPosition);
                if (lastMessage != null && dataSource.getShowTime() - lastMessage.getShowTime() > TIME_DIFFERENCE) {
                    mTimeLineTv.setVisibility(View.VISIBLE);
                    mTimeLineTv.setText(TimeUtil.convertChatTime(dataSource.getShowTime()));
                } else {
                    mTimeLineTv.setVisibility(View.GONE);
                }
            }
            //发送阅读回执
            if (itemData.getMessageState() < ConstDef.STATE_READED) {
                getPresenter().sendReadReceipt(itemData);
            }
        }
    }

    private void setTimeLineVisible(long time) {
        mTimeLineTv.setVisibility(View.VISIBLE);
        mTimeLineTv.setText(TimeUtil.convertChatTime(time));
    }
}
