package com.xdja.im.uikit.assistant.search.view;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.im.uikit.R;
import com.xdja.im.uikit.assistant.search.adapter.SearchAssistantAdapter;
import com.xdja.im.uikit.assistant.search.presenter.AssistantSearchPresenter;
import com.xdja.im.uikit.assistant.search.view.vu.AssistantSearchVu;
import com.xdja.im.uikit.base.ImFragmentSuperView;
import com.xdja.im.uikit.newui.base.SpaceItemDecoration;

/**
 * Created by wenqi on 2018/5/15.
 * 消息助手搜索View
 *
 */

public class AssistantSearchView extends ImFragmentSuperView<AssistantSearchPresenter> implements AssistantSearchVu {

    private RelativeLayout mContentLayout;

    /**
     * 消息列表控件
     */
    private RecyclerView mRecyclerView;

    /**
     * 网络状态组件
     *
     * @return
     */
    private LinearLayout networkStateLineaLayout;
    /**
     * 网络状态显示组件
     *
     * @return
     */
    private TextView networkStateTv;


    private RelativeLayout searchLayout;
    private EditText search_ed;


    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_search_assistant_layout;
    }

    @Override
    protected int getToolbarType() {
        return ToolbarDef.NAVIGATE_BACK;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mContentLayout = (RelativeLayout) findViewById(R.id.content_layout);
        mRecyclerView = (RecyclerView) findViewById(R.id.lv_message_list);
        networkStateLineaLayout = (LinearLayout) findViewById(R.id.network_state_view);
        networkStateTv = (TextView) findViewById(R.id.networkstate_tv);
        searchLayout = (RelativeLayout) findViewById(R.id.search_layout);
        search_ed = (EditText) findViewById(R.id.search_ed);
    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        setNavigateCallback(new onNavigateCallback() {
            @Override
            public void onBackClick() {
            }

            @Override
            public void onAddClick() {
                Toast.makeText(getActivity(),"设置",Toast.LENGTH_SHORT).show();
            }
        });
    }


    @Override
    public void setToolBarVisibility(int visibility) {
        supportActionBar(visibility == View.VISIBLE);
    }

    @Override
    public void setToolBarAddVisibility(int visibility) {
        setToolBarAddVisible(visibility == View.VISIBLE);
    }

    @Override
    public void setTitle(String title) {
        if (isSupportActionBar()) {
            setToolBarTitle(title);
        }
    }

    @Override
    public void setAdapter(SearchAssistantAdapter adapter) {
        mRecyclerView.setLayoutManager(getPresenter().getLinearLayoutManager());
        mRecyclerView.addItemDecoration(new SpaceItemDecoration(8));
        mRecyclerView.setAdapter(adapter);
    }

    @Override
    public RecyclerView getRecyclerView() {
        return mRecyclerView;
    }

}
