package com.xdja.im.uikit.assistant.view;

import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.im.uikit.R;
import com.xdja.im.uikit.assistant.adapter.MessageAssistantAdapter;
import com.xdja.im.uikit.assistant.presenter.MessageAssistantPresenter;
import com.xdja.im.uikit.assistant.view.vu.MessageAssistantVu;
import com.xdja.im.uikit.base.ImFragmentSuperView;
import com.xdja.im.uikit.newui.base.SpaceItemDecoration;

/**
 * Created by wenqi on 2018/5/8.
 * MessageAssistantView
 */

public class MessageAssistantView extends ImFragmentSuperView<MessageAssistantPresenter> implements MessageAssistantVu {



    private RelativeLayout mContentLayout;

    /**
     * 消息列表控件
     */
    private RecyclerView mRecyclerView;

    /**
     * 网络状态组件
     *
     * @return
     */
    private LinearLayout networkStateLineaLayout;
    /**
     * 网络状态显示组件
     *
     * @return
     */
    private TextView networkStateTv;
    /**
     * 下拉刷新组件
     */
    private SwipeRefreshLayout swipeRefreshLayout;
    /**
     * 目标项是否在最后一个可见项之后
     */
    private boolean mShouldScroll,isScrollView;
    /**
     * 记录目标项位置
     */
    private int mToPosition;


    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_message_assistant_layout;
    }

    @Override
    protected int getToolbarType() {
        return ToolbarDef.NAVIGATE_BACK;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mContentLayout = (RelativeLayout) findViewById(R.id.content_layout);
        mRecyclerView = (RecyclerView) findViewById(R.id.lv_message_list);
        swipeRefreshLayout = (SwipeRefreshLayout) findViewById(R.id.swipe_container);
        networkStateLineaLayout = (LinearLayout) findViewById(R.id.network_state_view);
        networkStateTv = (TextView) findViewById(R.id.networkstate_tv);

    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                getPresenter().downRefreshList();
            }
        });
        initChatListListView();
        setNavigateCallback(new onNavigateCallback() {
            @Override
            public void onBackClick() {
            }

            @Override
            public void onAddClick() {
                Toast.makeText(getActivity(),"设置",Toast.LENGTH_SHORT).show();
            }
        });
    }


    /**
     * 添加显示列表的监听事件
     */
    private void initChatListListView() {
        mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (mShouldScroll) {
                    mShouldScroll = false;
                    smoothMoveToPosition(mToPosition);
                }
            }

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (isScrollView){
                    isScrollView = false;
                    int lastItem = mRecyclerView.getAdapter().getItemCount()-1;
                    smoothMoveToPosition(lastItem);
                }
            }
        });
    }

    @Override
    public void setToolBarVisibility(int visibility) {
        supportActionBar(visibility == View.VISIBLE);
    }

    @Override
    public void setToolBarAddVisibility(int visibility) {
        setToolBarAddVisible(visibility == View.VISIBLE);
    }

    @Override
    public boolean isRefreshing() {
        return swipeRefreshLayout.isRefreshing();
    }

    @Override
    public void stopRefresh() {
        swipeRefreshLayout.setRefreshing(false);
    }

    @Override
    public void setTitle(String title) {
        if (isSupportActionBar()) {
            setToolBarTitle(title);
        }
    }

    @Override
    public void setAdapter(MessageAssistantAdapter adapter) {
        mRecyclerView.setLayoutManager(getPresenter().getLinearLayoutManager());
        mRecyclerView.addItemDecoration(new SpaceItemDecoration(8));
        mRecyclerView.setAdapter(adapter);
    }

    @Override
    public RecyclerView getRecyclerView() {
        return mRecyclerView;
    }

    @Override
    public void setListSelection(int selection) {
        smoothMoveToPosition(selection);
    }

    @Override
    public void smoothMoveToPosition(int index) {
        //获取当前recycleView屏幕可见的第一项和最后一项的Position
        int firstItem = getPresenter().getLinearLayoutManager().findFirstVisibleItemPosition();
        int lastItem = getPresenter().getLinearLayoutManager().findLastVisibleItemPosition();
        //然后区分情况
        if (index <= firstItem) {
            //当要置顶的项在当前显示的第一个项的前面时
            mRecyclerView.smoothScrollToPosition(index);
        } else if (index <= lastItem) {
            //当要置顶的项已经在屏幕上显示时，计算它离屏幕原点的距离
            int movePosition = index - firstItem;
            if (movePosition >= 0 && movePosition < mRecyclerView.getChildCount()) {
                int top = mRecyclerView.getChildAt(movePosition).getTop();
                mRecyclerView.smoothScrollBy(0, top);
            }
        } else {
            //当要置顶的项在当前显示的最后一项的后面时
            mRecyclerView.smoothScrollToPosition(index);
            //记录当前需要在RecyclerView滚动监听里面继续第二次滚动
            mToPosition = index;
            mShouldScroll = true;
        }
    }


}
