package com.xdja.im.uikit.assistant.view.vu;

import android.support.v7.widget.RecyclerView;

import com.xdja.im.base.frame.view.FragmentBaseView;
import com.xdja.im.uikit.assistant.adapter.MessageAssistantAdapter;
import com.xdja.im.uikit.assistant.presenter.MessageAssistantPresenter;

/**
 * Created by wenqi on 2018/5/8.
 */

public interface MessageAssistantVu extends FragmentBaseView<MessageAssistantPresenter> {


    /**
     * 设置ToolBar是否可见
     *
     * @param visibility
     */
    void setToolBarVisibility(int visibility);

    /**
     * 设置Toolbar上add功能是否可用
     *
     * @param visibility
     */
    void setToolBarAddVisibility(int visibility);
    /**
     * 是否正在下拉刷新中
     *
     * @return
     */
    boolean isRefreshing();

    /**
     * 停止下拉刷新
     */
    void stopRefresh();
    /**
     * 设置显示
     *
     * @param title
     */
    void setTitle(String title);

    /**
     * 设置适配器
     *
     * @param adapter 适配器
     */
    void setAdapter(MessageAssistantAdapter adapter);

    /**
     * 获取聊天列表控件
     *
     * @return
     */
    RecyclerView getRecyclerView();

    /**
     * 设置当前选中项<br>
     * 建议使用 setListSelection2Last
     *
     * @param selection
     */
    void setListSelection(int selection);


    void smoothMoveToPosition(int position);

}
