package com.xdja.im.uikit.newui.base;

import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.xdja.im.base.frame.Presenter;

import java.util.List;

/**
 * Created by wenqi on 2018/4/13.
 * RecyclerViewBaseAdapter
 */

public abstract class RecyclerViewBaseAdapter<D,P extends Presenter> extends RecyclerView.Adapter<RecyclerViewHolder> {

    protected List<D> list;
    protected D item;

    public RecyclerViewBaseAdapter(List<D> list) {
        this.list = list;
    }

    @Override
    public int getItemViewType(int position) {
        item = list.get(position);
        return getViewType(item);
    }

    protected abstract int getViewType(D d);

    @Override
    public RecyclerViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        RecyclerViewHolder recyclerViewHolder = getViewHolder(parent,viewType);
        recyclerViewHolder.setPresenter(getPresenter());
        return recyclerViewHolder;
    }

    protected abstract RecyclerViewHolder getViewHolder(ViewGroup parent, int viewType);

    protected View getItemView(ViewGroup parent,@LayoutRes int ids){
        return LayoutInflater.from(parent.getContext()).inflate(ids,parent,false);
    }

    @Override
    public void onBindViewHolder(RecyclerViewHolder holder, int position) {
        //强制关闭复用
        //holder.setIsRecyclable(false);
        holder.bindData(position,getItemData(position));
    }

    protected D getItemData(int position) {
        return list == null ? null : list.get(position);
    }

    @Override
    public int getItemCount() {
        return list == null ? 0 : list.size();
    }

    protected abstract P getPresenter();
}
