package com.xdja.im.uikit.newui.base;

import android.content.res.Resources;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.xdja.im.base.frame.Presenter;
import com.xdja.im.uikit.utils.log.LogUtil;

import static android.view.View.NO_ID;

/**
 * Created by wenqi on 2018/4/13.
 *
 */

public abstract class RecyclerViewHolder<D,P extends Presenter> extends RecyclerView.ViewHolder {


    protected View itemView;
    private P presenter;
    protected D dataSource;
    protected int curPosition;

    public RecyclerViewHolder(View itemView) {
        super(itemView);
        this.itemView = itemView;
    }

    public final <T extends View> T findViewById(@IdRes int id) {
        if (id == NO_ID) {
            return null;
        }
        return itemView.findViewById(id);
    }

    /**
     * 获取String字符串
     *
     * @param res 字符串资源ID
     * @return 目标字符串
     */
    @NonNull
    public String getStringRes(@StringRes int res) {
        return itemView.getContext().getString(res);
    }
    /**
     * 获取资源实例
     *
     * @return
     */
    public Resources getResources() {
        return itemView.getContext().getResources();
    }


    public void bindData(int position,D itemData){
        if (itemData == null) {
            LogUtil.e("Action:set message state, reason: dataSource is null.");
            return;
        }

        this.curPosition = position;
        this.dataSource = itemData;
    }


    public void setPresenter(P presenter) {
        this.presenter = presenter;
    }

    public P getPresenter() {
        return presenter;
    }

}
