package com.xdja.im.uikit.newui.holder;

import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.google.gson.Gson;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.custom.CustomMsgInfo;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.constans.Constant;
import com.xdja.im.uikit.newui.base.BaseChatHolder;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by wenqi on 2018/4/13.
 */

public class ViewCustomSendMeetingHolder extends BaseChatHolder {


    private ImageView imgCustomType;
    private TextView tvCustominfo;
    private LinearLayout linearLayout;
    private CustomMsgInfo customMsgInfo;
    private Gson gson = new Gson();


    public ViewCustomSendMeetingHolder(View itemView) {
        super(itemView);
        imgCustomType = (ImageView) findViewById(R.id.img_custom_send);
        tvCustominfo = (TextView) findViewById(R.id.tv_send_info);
        linearLayout = (LinearLayout) findViewById(R.id.layout_message_container);
        linearLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                final CustomMsgInfo customMsgInfo = gson.fromJson(dataSource.getContent(), CustomMsgInfo.class);
                int type = customMsgInfo.getType();
                switch (type) {
                    case ConstDef.CALLBACK_P2P:
                    case ConstDef.VIDEO_CHAT:
                        IMUiKitProxyImpl.getInstance().startCallback(customMsgInfo.getToAtNo());
                        break;
                    case ConstDef.CALLBACK_P2G:
                        break;
                    case ConstDef.MEETING_P2P:
                        IMUiKitProxyImpl.getInstance().startVoice(customMsgInfo.getToAtNo() , ConstDef.CHAT_TYPE_P2P);
                        break;
                    case ConstDef.MEETING_P2G:
                        IMUiKitProxyImpl.getInstance().startVoice(customMsgInfo.getToAtNo(), ConstDef.CHAT_TYPE_P2G);
                        break;
                }
            }
        });
        linearLayout.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                List<ImOption> data = new ArrayList<>();
                data.add(mImOptions.get(0));
                mPopDialog.addData(data);
                mPopDialog.show(curPosition);
                return true;
            }
        });
        mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener() {
            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                mPopDialog.dismiss();
                switch (option.getOptionType()) {
                    case Constant.ITEM_CHAT_DELETE:  //删除消息
                        getPresenter().deleteItem(itemPosition);
                        break;
                }
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        customMsgInfo = gson.fromJson(dataSource.getContent(), CustomMsgInfo.class);
        int type = customMsgInfo.getType();
        int state = customMsgInfo.getState();
        long amountOfTime = customMsgInfo.getAmountOfTime();
        String content = "";
        if (state == ConstDef.SENDER_CANCEL) {
            content = "已取消";
        } else if (state == ConstDef.NO_RESPONSE) {
            content = "对方无应答";
        } else if (state == ConstDef.RECER_CANCEL) {
            content = "对方已拒绝";
        } else if (state == ConstDef.OVER) {
            content = buildMsgContent(type, amountOfTime);
        }
        if (type == ConstDef.CALLBACK_P2P || type == ConstDef.CALLBACK_P2G|| type == ConstDef.VIDEO_CHAT) {
            imgCustomType.setImageResource(R.mipmap.im_uikit_icon_custom_callback_sender);
        } else {
            imgCustomType.setImageResource(R.mipmap.im_uikit_icon_custom_meeting_sender);
        }
        tvCustominfo.setText(content);
    }

    private String buildMsgContent(int type, long amountOfTime) {
        StringBuilder builder = new StringBuilder();
        switch (type) {
            case ConstDef.CALLBACK_P2P:
            case ConstDef.CALLBACK_P2G:
                builder.append("视频回传");
                builder.append(" " + getFormatTime(amountOfTime));
                break;
            case ConstDef.VIDEO_CHAT:
                builder.append("视频通话");
                builder.append(" " + getFormatTime(amountOfTime));
                break;
            case ConstDef.MEETING_P2P:
                builder.append("语音通话");
                builder.append(" " + getFormatTime(amountOfTime));
                break;
            case ConstDef.MEETING_P2G:
                builder.append("语音会议");
                break;
        }
        return builder.toString();
    }

    private String getFormatTime(long amountOfTime) {
        long hour = amountOfTime / 3600;
        long min = amountOfTime / 60 % 60;
        long second = amountOfTime % 60;
        String hourStr = "";
        String minStr = min < 10 ? "0" + min : "" + min;
        String secondStr = second < 10 ? "0" + second : "" + second;
        if(hour == 0) {
            hourStr = "";
            return minStr + ":" + secondStr;
        }else {
            hourStr = hour < 10 ? "0" + hour : "" + hour;
            return hourStr + ":" + minStr + ":" + secondStr;
        }
    }
}
