package com.xdja.im.uikit.newui.holder;

import android.view.View;
import android.widget.LinearLayout;

import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseChatHolder;
import com.xdja.im.uikit.view.AutoSplitTextView;

/**
 * Created by wenqi on 2018/4/13.
 */

public class ViewNotifyHolder extends BaseChatHolder {

    /**
     * 通知消息
     */
//    private ShowTextView mNotifyTv;
    private AutoSplitTextView mNotifyTv;
    private LinearLayout tv_notify_layout;

    public ViewNotifyHolder(View itemView) {
        super(itemView);
        tv_notify_layout = (LinearLayout) findViewById(R.id.tv_notify_layout);
        mNotifyTv = (AutoSplitTextView) findViewById(R.id.tv_notify);
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        tv_notify_layout.setVisibility(View.VISIBLE);
        mNotifyTv.setText(dataSource.getContent());
    }
}
