package com.xdja.im.uikit.newui.holder.receive;

import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseReceHolder;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.file.TranslateInfoUtil;
import com.xdja.im.uikit.utils.log.LogUtil;

/**
 * Created by wenqi on 2018/4/13.
 */

public class ViewReceFileHolder extends BaseReceHolder {

    /**
     * 文件标识图标
     */
    private ImageView mFileIconImg;
    /**
     * 文件名称
     */
    private TextView mFileNameTv;
    /**
     * 文件时间
     */
    private TextView mFileSizeTv;
    /**
     * 文件发送进度
     */
    private ProgressBar mLoadingPBar;
    /**
     * 下载状态图标
     */
    private ImageView mDownloadStateImg;

    public ViewReceFileHolder(View itemView) {
        super(itemView);
        mFileIconImg = (ImageView) findViewById(R.id.img_file_flag);
        mFileNameTv = (TextView) findViewById(R.id.tv_file_name);
        mFileSizeTv = (TextView) findViewById(R.id.tv_file_size);
        mLoadingPBar = (ProgressBar) findViewById(R.id.pbar_file_progress);
        mDownloadStateImg = (ImageView) findViewById(R.id.img_download_state);

        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                NormalFileInfo fileInfo = (NormalFileInfo) dataSource.getFileInfo();
                if (fileInfo == null) {
                    LogUtil.e("ERROR: start open file, but file info is null.");
                    return;
                }
                if (fileInfo.getFileState() == ConstDef.DONE) {
                    getPresenter().openNormalFile(dataSource);
                } else {
                    getPresenter().loadNormalFile(dataSource);
                }
            }
        });
    }


    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);

        NormalFileInfo fileInfo = (NormalFileInfo) dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: receive file info is null error.");
            return;
        }

        //文件图标
        if (fileInfo.getFileState() != ConstDef.DONE
                && fileInfo.getFileState() != ConstDef.INACTIVE
                && fileInfo.getFileState() != ConstDef.FAIL) {
            mDownloadStateImg.setImageResource(getStateImage(fileInfo));
            mLoadingPBar.setVisibility(View.VISIBLE);
            mLoadingPBar.setProgress((int) (getTranslateSize(fileInfo) * 100.0f / fileInfo.getFileSize()));
        } else {
            if (fileInfo.getFileState() == ConstDef.FAIL) {
                mDownloadStateImg.setImageResource(getStateImage(fileInfo));
            } else {
                mDownloadStateImg.setImageDrawable(null);
            }
            mLoadingPBar.setVisibility(View.GONE);
        }

        mFileIconImg.setImageResource(FileUtils.getIconWithSuffix(fileInfo.getFilePath()));
        mFileNameTv.setText(fileInfo.getFileName());
        mFileSizeTv.setText(FileSizeUtils.formatFileSize(fileInfo.getFileSize()));

    }



    /**
     * 获取文件传输大小
     *
     * @param fileInfo
     * @return
     */
    private long getTranslateSize(NormalFileInfo fileInfo) {
        return Math.max(TranslateInfoUtil.getTranslateSize(fileInfo.getTalkMessageId()),
                fileInfo.getTranslateSize());
    }

    /**
     * 获取状态标识
     *
     * @param fileInfo
     * @return
     */
    private int getStateImage(FileInfo fileInfo) {
        int res = 0;
        if (fileInfo.getFileState() == ConstDef.LOADING) {
            res = R.mipmap.im_uikit_ic_download_normal;
        } else if (fileInfo.getFileState() == ConstDef.FAIL) {
            res = R.mipmap.im_uikit_ic_again_normal;
        } else if (fileInfo.getFileState() == ConstDef.PAUSE) {
            res = R.mipmap.im_uikit_ic_suspend_normal;
        }
        return res;
    }

}
