package com.xdja.im.uikit.newui.holder.receive;

import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseReceHolder;

/**
 * Created by wenqi on 2018/4/13.
 */

public class ViewReceTextHolder extends BaseReceHolder {

    /**
     * 消息显示文本
     */
    private TextView mContentTv;


    public ViewReceTextHolder(View itemView) {
        super(itemView);
        mContentTv = (TextView) findViewById(R.id.tv_content);
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        if (dataSource.getMessageState() == ConstDef.STATE_DESTROY) {
            setMessageDestroy(true);
            setRecContentTextColor(getLimitTextColor());
            setRecContentText(R.string.im_uikit_text_bomb);
        } else {
            setMessageDestroy(false);
            setRecContentTextColor(getNormalTextColor());
            if (!TextUtils.isEmpty(dataSource.getContent())) {
                setRecContentText(EmotionUtils.formatNormalSpanContent(dataSource.getContent(),
                        getPresenter().getActivity()));
            } else {
                //setRecContentText(String.valueOf(""));
            }

            //发送阅读回执
            if (dataSource.getMessageState() < ConstDef.STATE_READED) {
                getPresenter().sendReadReceipt(dataSource);
            }

            //开始执行销毁动画
            if (dataSource.getMessageState() == ConstDef.STATE_DESTROYING) {
                startBombAnim();
                final TalkMessageBean cloneObj = new TalkMessageBean(dataSource);
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        getPresenter().postDestroyAnimate(cloneObj);
                    }
                }, 700);
            }

        }
    }


    private void setRecContentTextColor(int colorId) {
        if (mContentTv != null) {
            mContentTv.setTextColor(colorId);
        }
    }

    private void setRecContentText(int contentTextId) {
        if (mContentTv != null) {
            mContentTv.setText(contentTextId);
        }
    }

    private void setRecContentText(CharSequence contentText) {
        if (mContentTv != null) {
            mContentTv.setText(contentText);
        }
    }

}
