package com.xdja.im.uikit.newui.holder.receive;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.share.model.WebPageInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseReceHolder;
import com.xdja.im.uikit.view.CircleImageView;

/**
 * Created by wenqi on 2018/4/13.
 */

public class ViewReceWebHolder extends BaseReceHolder {

    private final static String TAG = "ViewSendWebItem";

    private TextView recvWebTitle;
    private TextView recvWebDes;
    private ImageView recvWebThumb;
    private CircleImageView ivHeader;

    public ViewReceWebHolder(View itemView) {
        super(itemView);
        recvWebTitle = (TextView) findViewById(R.id.web_title);
        recvWebDes = (TextView) findViewById(R.id.web_des);
        recvWebThumb = (ImageView) findViewById(R.id.web_thumb);
        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().clickWebMessage(dataSource);
            }
        });
    }

    @Override
    public void bindData(int position, final TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        WebPageInfo webPageInfo = dataSource.getWebPageInfo();
        if (webPageInfo != null){
            String webUri = webPageInfo.getWebUri();
            String description = webPageInfo.getDescription();
            String source = webPageInfo.getSource();
            String title = webPageInfo.getTitle();
            recvWebTitle.setText(title);
            recvWebTitle.setText(description);
        }

    }
}
