package com.xdja.im.uikit.newui.holder.send;

import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseSendHolder;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.file.TranslateInfoUtil;
import com.xdja.im.uikit.utils.log.LogUtil;

/**
 * Created by wenqi on 2018/4/13.
 * 发送文件
 */

public class ViewSendFileHolder extends BaseSendHolder {

    /**
     * 文件类型logo
     */
    private ImageView mLogoImg;
    /**
     * 文件名称
     */
    private TextView mFileNameTv;
    /**
     * 文件大小
     */
    private TextView mFileSizeTv;
    /**
     * 文件下载进度条
     */
    private ProgressBar mLoadingPBar;

    public ViewSendFileHolder(View itemView) {
        super(itemView);
        mLogoImg = (ImageView) findViewById(R.id.img_file_flag);
        mFileNameTv = (TextView) findViewById(R.id.tv_file_name);
        mFileSizeTv = (TextView) findViewById(R.id.tv_file_size);
        mLoadingPBar = (ProgressBar) findViewById(R.id.pbar_file_progress);

        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().openNormalFile(dataSource);
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        NormalFileInfo normalFileInfo = (NormalFileInfo) dataSource.getFileInfo();
        if (normalFileInfo == null) {
            LogUtil.e("ERROR: Send file info is null.");
            return;
        }

        mFileNameTv.setText(normalFileInfo.getFileName());
        mFileSizeTv.setText(FileSizeUtils.formatFileSize(normalFileInfo.getFileSize()));
        loadLogo(normalFileInfo.getFilePath());

        //要上传的文件已经存在并且未上传完成的情况下，显示进度条
        if (dataSource.getMessageState() == ConstDef.STATE_SENDING) {
            mLoadingPBar.setVisibility(View.VISIBLE);
            mLoadingPBar.setProgress((int) (getTranslateSize(normalFileInfo) * 100.0f / normalFileInfo.getFileSize()));
        } else {
            mLoadingPBar.setVisibility(View.GONE);
        }
    }


    /**
     * 获取文件传输大小
     *
     * @param fileInfo
     * @return
     */
    private long getTranslateSize(NormalFileInfo fileInfo) {
        return Math.max(TranslateInfoUtil.getTranslateSize(fileInfo.getTalkMessageId()),
                fileInfo.getTranslateSize());
    }

    private void loadLogo(String filePath) {
        if (FileUtils.isFileExists(filePath)) {
            mLogoImg.setImageResource(FileUtils.getIconWithSuffix(filePath));
        } else {
            mLogoImg.setImageResource(R.mipmap.im_uikit_ic_others);
        }
    }
}
