package com.xdja.im.uikit.newui.holder.send;

import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseSendHolder;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;

import static com.xdja.im.lib.filemanage.util.HistoryFileUtils.isFileExist;

/**
 * Created by wenqi on 2018/4/13.
 */

public class ViewSendImageHolder extends BaseSendHolder {

    //private static final int MAX_PLAY_GIF = 3 * 1024 * 1024;

    /**
     * 图片加载显示控件
     */
    private ChatImageView mChatImage;
    /**
     * gif
     */
    private ImageView mGifImageView;
    /**
     * 闪信标识
     */
    private ImageView mBombFlagImg;



    public ViewSendImageHolder(View itemView) {
        super(itemView);
        mChatImage = (ChatImageView) findViewById(R.id.img_send_image);
        mGifImageView = (ImageView) findViewById(R.id.img_send_gif_image);
        mBombFlagImg = (ImageView) findViewById(R.id.img_bomb_flag);

        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().previewImage(dataSource);
            }
        });
    }


    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        ImageFileInfo fileInfo = (ImageFileInfo) dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("load image, but file info is null");
            mChatImage.setError(R.mipmap.im_uikit_pic_failed);
            return;
        }

        //加载图片
        loadImage(fileInfo, dataSource);

        //闪信标识
        if (dataSource.isBomb()) {
            mBombFlagImg.setVisibility(View.VISIBLE);
        }
    }



    private void loadImage(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        //本地图片存在
        if (FileUtils.isFileExists(imageFileInfo.getFilePath())) {
            //mChatImage.loadImage(filePath);
            loadImageUrl(imageFileInfo, dataSource);
        } else {
            LogUtil.w("file is not exit.");
            mChatImage.setError(R.mipmap.im_uikit_pic_default);
        }
    }

    /**
     * 加载URL指定图片
     *
     * @param imageFileInfo
     */
    private void loadImageUrl(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        String suffix = imageFileInfo.getSuffix();
        //fix bug 21243 by jyg 20171017
        if (imageFileInfo != null && ConstDef.GIF_TYPE.equalsIgnoreCase(suffix)
                && !TextUtils.isEmpty(imageFileInfo.getFilePath())) {
            String urlGif = imageFileInfo.getFilePath();
            long fileSize = imageFileInfo.getFileSize();
            //fix bug 21243 by jyg 20171017
            mChatImage.setVisibility(View.GONE);
            mGifImageView.setVisibility(View.VISIBLE);
            if (isFileExist(urlGif)) {
                Glide.with(getActivity())
                        .load(urlGif)
                        .placeholder(R.mipmap.im_uikit_pic_default)
                        .diskCacheStrategy(DiskCacheStrategy.SOURCE)
                        .into(mGifImageView);
            }
        } else {
            mChatImage.setVisibility(View.VISIBLE);
            mGifImageView.setVisibility(View.GONE);
            mChatImage.loadImage(imageFileInfo.getFilePath());
        }
    }
}
