package com.xdja.im.uikit.newui.holder.send;

import android.view.View;
import android.widget.TextView;

import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseSendHolder;

/**
 * Created by wenqi on 2018/4/13.
 */

public class ViewSendTextHolder extends BaseSendHolder {

    /**
     * 文本消息显示控件
     */
    private TextView mContentTv;


    public ViewSendTextHolder(View itemView) {
        super(itemView);
        mContentTv = (TextView) findViewById(R.id.tv_content);
    }


    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        mContentTv.setText(
                EmotionUtils.formatNormalSpanContent(dataSource.getContent(),
                        getPresenter().getActivity())
        );
    }
    @Override
    protected void setTxtContentColor(int color) {
        super.setTxtContentColor(color);
        mContentTv.setTextColor(color);
    }
}
