package com.xdja.im.uikit.newui.holder.send;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseSendHolder;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;
import com.xdja.im.uikit.view.CircleProgressBar;

/**
 * Created by wenqi on 2018/4/13.
 */

public class ViewSendVideoHolder extends BaseSendHolder {

    /**
     * 图片加载显示控件
     */
    private ChatImageView mChatImage;
    /**
     * 播放标识
     */
    private ImageView mPlayFlagImg;
    /**
     * 文件发送进度
     */
    private CircleProgressBar mLoadingPBar;
    /**
     * 视频时长显示
     */
    private TextView mVideoTimeTv;

    public ViewSendVideoHolder(View itemView) {
        super(itemView);
        mChatImage = (ChatImageView) findViewById(R.id.img_send_image);
        mPlayFlagImg = (ImageView) findViewById(R.id.img_play_flag);
        mLoadingPBar = (CircleProgressBar) findViewById(R.id.pbar_video_loading);
        mVideoTimeTv = (TextView) findViewById(R.id.tv_video_duration);

        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().previewVideo(dataSource);
            }
        });
        mPlayFlagImg.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().previewVideo(dataSource);
            }
        });
        mPlayFlagImg.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                return showPopDialog();
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        VideoFileInfo videoFileInfo = (VideoFileInfo) dataSource.getFileInfo();
        if (videoFileInfo == null) {
            LogUtil.e("Video file info is null error.");
            return;
        }
        mPlayFlagImg.setVisibility(View.VISIBLE);
        mVideoTimeTv.setVisibility(View.VISIBLE);

        //更新进度
        updateProgress(videoFileInfo.getTranslatePercent());
        //加载缩略图
        loadImage(videoFileInfo.getFilePath());

        mVideoTimeTv.setText(String.format(getStringRes(R.string.im_uikit_video_duration),
                videoFileInfo.getAmountOfTime() / 60,   //分
                videoFileInfo.getAmountOfTime() % 60)); //秒
    }

    /**
     * 加载视频第一帧图片
     *
     * @param filePath
     */
    private void loadImage(String filePath) {
        if (FileUtils.isFileExists(filePath)) {
            mChatImage.loadImage(filePath);
        } else {
            mVideoTimeTv.setVisibility(View.GONE);
            mPlayFlagImg.setVisibility(View.GONE);
            mChatImage.setError(R.mipmap.im_uikit_ic_video_failed);
        }
    }

    /**
     * 更新文件加载进度
     *
     * @param percent 视频文件发送进度
     */
    private void updateProgress(int percent) {
        if (dataSource.getMessageState() == ConstDef.STATE_SENDING) {
            mPlayFlagImg.setVisibility(View.GONE);
            mLoadingPBar.setVisibility(View.VISIBLE);
            mLoadingPBar.setProgress(percent);
        } else {
            mPlayFlagImg.setVisibility(View.VISIBLE);
            mLoadingPBar.setVisibility(View.GONE);
        }
    }
}
