package com.xdja.im.uikit.newui.holder.send;

import android.graphics.drawable.AnimationDrawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.VoiceFileInfo;
import com.xdja.im.core.model.screen.ScreenInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseSendHolder;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.ScreenUtil;

/**
 * Created by wenqi on 2018/4/13.
 */

public class ViewSendVoiceHolder extends BaseSendHolder {

    /**
     * 语音信息气泡长度DP值
     */
    private static final int MIN_DP = 80;
    private static final int FIRST_STEP_DP = 140;
    private static final int SECOND_STEP_DP = 180;
    private static final int MAX_DP = 200;

    /**
     * 语音时长提示
     */
    private TextView mVoiceLength;

    /**
     * 语音图标
     */
    private ImageView mVoiceAnimImg;

    /**
     * 屏幕信息
     */
    private ScreenInfo mScreenInfo;

    public ViewSendVoiceHolder(View itemView) {
        super(itemView);
        mVoiceLength = (TextView) findViewById(R.id.tv_hint_time);
        mVoiceAnimImg = (ImageView) findViewById(R.id.img_anim_voice);

        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().playVoice(dataSource);
            }
        });
    }


    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);

        mScreenInfo = ScreenUtil.getScreenInfo(getPresenter().getActivity());
        initView();
    }


    private void initView() {

        VoiceFileInfo fileInfo = (VoiceFileInfo) dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("file info is null error.");
            return;
        }

        int recordingTime = fileInfo.getAmountOfTime();
        setBackground(recordingTime);
        setVoiceLengthText(recordingTime);

        mVoiceAnimImg.setBackgroundResource(R.drawable.im_uikit_bg_voice_send_anim);
        if(dataSource.isBomb()){
            mVoiceAnimImg.setBackgroundResource(R.drawable.im_uikit_bg_voice_send_white_anim);
        }

        if (getPresenter().getVoiceMessageIsPlaying(fileInfo)) {
            startVoiceAnim();
        } else {
            stopVoiceAnim();
        }
    }

    /**
     * 语音背景框，计算语音显示的长度
     *
     * @param recordingTime 录音文件时长
     */
    private void setBackground(int recordingTime) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) mContentLayout.getLayoutParams();
        float bubbleLength;//语音气泡长度
        if (recordingTime <= 10) {
            bubbleLength = (MIN_DP + (FIRST_STEP_DP - MIN_DP) / 10 *
                    recordingTime) * mScreenInfo.getDensity();
        } else if (recordingTime <= 20) {
            bubbleLength = (FIRST_STEP_DP + (SECOND_STEP_DP - FIRST_STEP_DP) / 10 *
                    (recordingTime - 10)) * mScreenInfo.getDensity();
        } else if (recordingTime <= 30) {
            bubbleLength = (SECOND_STEP_DP + (MAX_DP - SECOND_STEP_DP) / 10 *
                    (recordingTime - 20)) * mScreenInfo.getDensity();
        } else {
            bubbleLength = MAX_DP * mScreenInfo.getDensity();
        }
        params.width = (int) bubbleLength;
        mContentLayout.setLayoutParams(params);
    }

    /**
     * 设置语音时长
     *
     * @param length 语音时长，单位s
     */
    private void setVoiceLengthText(int length) {
        mVoiceLength.setText((length == 0 ? 1 : length) + "\"");
    }

    /**
     * 开始语音播放动画
     */
    private void startVoiceAnim() {
        if (mVoiceAnimImg != null) {
            AnimationDrawable voiceAnim = (AnimationDrawable) mVoiceAnimImg.getBackground();
            if (voiceAnim != null) {
                if (!voiceAnim.isRunning()) {
                    voiceAnim.start();
                }
            }
        }
    }

    /**
     * 停止语音播放动画
     */
    private void stopVoiceAnim() {
        if (mVoiceAnimImg != null) {
            AnimationDrawable voiceAnim = (AnimationDrawable) mVoiceAnimImg.getBackground();
            if (voiceAnim != null) {
                voiceAnim.stop();
                voiceAnim.selectDrawable(0);
            }
        }
    }

    @Override
    protected void setTxtContentColor(int color) {
        super.setTxtContentColor(color);
        mVoiceLength.setTextColor(color);
    }

}
